@extends('layouts.admin')

@section('title', 'Stat Holidays')
@section('page_title', 'Stat Holidays')

@section('content')
    <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Stat Holidays</h1>
            <p class="text-gray-500 text-sm">Manage company-specific stat holidays and their SIN rate multipliers.</p>
        </div>
        <div class="flex items-center gap-3">
            <form action="{{ route('admin.stat-holidays.index') }}" method="GET" class="flex items-center gap-2">
                <select name="company_id" onchange="this.form.submit()"
                    class="bg-white border border-gray-200 text-sm rounded-xl px-4 py-2.5 focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all font-semibold">
                    <option value="">All Companies</option>
                    @foreach($companies as $company)
                        <option value="{{ $company->id }}" {{ request('company_id') == $company->id ? 'selected' : '' }}>
                            {{ $company->name }}
                        </option>
                    @endforeach
                </select>
            </form>
            <a href="{{ route('admin.stat-holidays.create') }}"
                class="inline-flex items-center gap-2 bg-blue-600 text-white px-4 py-2.5 rounded-xl font-semibold hover:bg-blue-700 transition-all shadow-lg shadow-blue-200">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6">
                    </path>
                </svg>
                Add Holiday
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded-xl flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead class="bg-[#1e293b]">
                <tr>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Holiday Name</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Company</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Date</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">SIN Multiplier</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Status</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                @forelse($statHolidays as $holiday)
                    <tr class="hover:bg-gray-50/50 transition-colors">
                        <td class="px-6 py-4">
                            <span class="text-sm font-bold text-gray-900">{{ $holiday->name }}</span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600 font-medium">
                            {{ $holiday->company->name }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600 font-medium">
                            {{ date('M d, Y', strtotime($holiday->holiday_date)) }}
                        </td>
                        <td class="px-6 py-4">
                            <span
                                class="px-2.5 py-1 bg-blue-50 text-blue-700 text-xs font-bold rounded-lg uppercase tracking-wider border border-blue-100">
                                {{ number_format($holiday->multiplier, 2) }}x
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <button type="button"
                                onclick="toggleStatus('{{ route('admin.stat-holidays.toggle-status', $holiday) }}', this)"
                                class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-blue-600 focus:ring-offset-2 {{ $holiday->active ? 'bg-blue-600' : 'bg-gray-200' }}"
                                role="switch" aria-checked="{{ $holiday->active ? 'true' : 'false' }}">
                                <span aria-hidden="true"
                                    class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out {{ $holiday->active ? 'translate-x-5' : 'translate-x-0' }}"></span>
                            </button>
                        </td>
                        <td class="px-6 py-4 text-right">
                            <div class="flex items-center justify-end gap-2">
                                <a href="{{ route('admin.stat-holidays.edit', $holiday) }}"
                                    class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-all"
                                    title="Edit">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z">
                                        </path>
                                    </svg>
                                </a>
                                <button type="button"
                                    onclick="openDeleteModal('{{ route('admin.stat-holidays.destroy', $holiday) }}', '{{ $holiday->name }}')"
                                    class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all"
                                    title="Delete">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                        </path>
                                    </svg>
                                </button>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center text-gray-500 italic">
                            No stat holidays found.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        @if($statHolidays->hasPages())
            <div class="px-6 py-4 border-t border-gray-50">
                {{ $statHolidays->links() }}
            </div>
        @endif
    </div>
@endsection