@extends('layouts.admin')

@section('title', 'Add Stat Holiday')
@section('page_title', 'Stat Holidays')

@section('content')
    <div class="max-w-3xl mx-auto">
        <div class="mb-6">
            <a href="{{ route('admin.stat-holidays.index') }}"
                class="text-blue-600 font-bold flex items-center gap-2 hover:underline">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                    </path>
                </svg>
                Back to List
            </a>
        </div>

        <div class="bg-white rounded-3xl border border-gray-100 shadow-xl overflow-hidden">
            <div class="p-8 bg-[#1e293b] text-white">
                <h1 class="text-2xl font-bold">Add Stat Holiday</h1>
                <p class="text-slate-400 text-sm mt-1">Configure a new company-specific stat holiday.</p>
            </div>

            <form action="{{ route('admin.stat-holidays.store') }}" method="POST" class="p-8 space-y-6">
                @csrf

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Select Company -->
                    <div class="md:col-span-2">
                        <label class="block text-xs font-bold text-gray-400 uppercase mb-2">Company <span
                                class="text-red-500">*</span></label>
                        <select name="company_id" required
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 outline-none transition-all font-bold">
                            <option value="">Select Company</option>
                            @foreach($companies as $company)
                                <option value="{{ $company->id }}" {{ old('company_id') == $company->id ? 'selected' : '' }}>
                                    {{ $company->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('company_id') <p class="mt-1 text-xs text-red-500 font-bold uppercase tracking-tight">
                        {{ $message }}</p> @enderror
                    </div>

                    <!-- Holiday Name -->
                    <div class="md:col-span-2">
                        <label class="block text-xs font-bold text-gray-400 uppercase mb-2">Holiday Name <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="name" value="{{ old('name') }}" required placeholder="e.g. Christmas Day"
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 outline-none transition-all font-bold">
                        @error('name') <p class="mt-1 text-xs text-red-500 font-bold uppercase tracking-tight">
                        {{ $message }}</p> @enderror
                    </div>

                    <!-- Holiday Date -->
                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase mb-2">Holiday Date <span
                                class="text-red-500">*</span></label>
                        <input type="date" name="holiday_date" value="{{ old('holiday_date') }}" required
                            class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 outline-none transition-all font-bold">
                        @error('holiday_date') <p class="mt-1 text-xs text-red-500 font-bold uppercase tracking-tight">
                        {{ $message }}</p> @enderror
                    </div>

                    <!-- Multiplier -->
                    <div>
                        <label class="block text-xs font-bold text-gray-400 uppercase mb-2">SIN Multiplier <span
                                class="text-red-500">*</span></label>
                        <div class="relative">
                            <input type="number" step="0.01" name="multiplier" value="{{ old('multiplier', '1.50') }}"
                                required
                                class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 outline-none transition-all font-bold">
                            <span class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 font-bold">x</span>
                        </div>
                        <p class="mt-2 text-[10px] text-gray-400 font-bold uppercase tracking-widest">Multiplier for the
                            guard's SIN rate</p>
                        @error('multiplier') <p class="mt-1 text-xs text-red-500 font-bold uppercase tracking-tight">
                        {{ $message }}</p> @enderror
                    </div>
                </div>

                <div class="pt-6 border-t border-gray-100 flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="hidden" name="active" value="0">
                            <input type="checkbox" name="active" value="1" class="sr-only peer" checked>
                            <div
                                class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600">
                            </div>
                            <span class="ml-3 text-sm font-bold text-gray-400 uppercase">Active Status</span>
                        </label>
                    </div>

                    <div class="flex gap-3">
                        <button type="reset"
                            class="px-6 py-3 bg-gray-100 text-gray-500 font-bold rounded-xl hover:bg-gray-200 transition-all">Reset</button>
                        <button type="submit"
                            class="px-10 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 shadow-lg shadow-blue-200 transition-all active:scale-95">Save
                            Holiday</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection