@extends('layouts.admin')

@section('title', 'System Settings')
@section('page_title', 'System Settings')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">System Maintenance</h1>
        <p class="text-gray-500 text-sm mt-1">Perform critical system operations like database migrations and cache
            clearing.</p>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            <div>
                <p class="font-bold">Success</p>
                <p class="text-sm">{{ session('success') }}</p>
            </div>
        </div>
    @endif

    @if($errors->any())
        <div class="mb-6 p-4 bg-red-50 border border-red-100 text-red-700 rounded-lg flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
            </svg>
            <div>
                <p class="font-bold">Error</p>
                <ul class="list-disc list-inside text-sm">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-4xl">
        <!-- Database Migration -->
        <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                <h3 class="text-lg font-bold text-gray-800 flex items-center gap-2">
                    <svg class="w-5 h-5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 7v10c0 2.21 3.582 4 8 4s8-1.79 8-4V7M4 7c0 2.21 3.582 4 8 4s8-1.79 8-4M4 7c0-2.21 3.582-4 8-4s8 1.79 8 4m0 5c0 2.21-3.582 4-8 4s-8-1.79-8-4">
                        </path>
                    </svg>
                    Database Migration
                </h3>
            </div>
            <div class="p-6">
                <p class="text-gray-600 text-sm mb-4">
                    Run database migrations to update the schema. This should be done after an update or when new features
                    require database changes.
                </p>
                <form action="{{ route('admin.settings.system.migrate') }}" method="POST"
                    onsubmit="return confirm('Are you sure you want to run database migrations? make sure you have a backup.');">
                    @csrf
                    <button type="submit"
                        class="w-full px-4 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-colors shadow-sm text-sm">
                        Run Migrations
                    </button>
                </form>
            </div>
        </div>

        <!-- Clear Cache -->
        <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                <h3 class="text-lg font-bold text-gray-800 flex items-center gap-2">
                    <svg class="w-5 h-5 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10">
                        </path>
                    </svg>
                    Clear System Cache
                </h3>
            </div>
            <div class="p-6">
                <p class="text-gray-600 text-sm mb-4">
                    Clear application, route, and configuration cache. Use this if you are not seeing recent changes or if
                    the application is behaving unexpectedly.
                </p>
                <form action="{{ route('admin.settings.system.clear-cache') }}" method="POST">
                    @csrf
                    <button type="submit"
                        class="w-full px-4 py-2 bg-amber-500 text-white font-bold rounded-lg hover:bg-amber-600 transition-colors shadow-sm text-sm">
                        Clear Cache
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection