@extends('layouts.admin')

@section('title', 'Security Settings')

@section('content')
    <div class="p-6">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Security Settings</h1>
            <p class="text-gray-500 text-sm mt-1">Manage application security and login throttling policies.</p>
        </div>

        @if(session('success'))
            <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                {{ session('success') }}
            </div>
        @endif

        <form action="{{ route('admin.settings.security.update') }}" method="POST" class="max-w-4xl">
            @csrf

            <!-- Login Throttling Section -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden mb-6">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                    <h3 class="text-lg font-bold text-gray-800">Login Throttling</h3>
                    <p class="text-gray-500 text-xs mt-1">Protect against brute-force attacks by limiting login attempts.
                    </p>
                </div>

                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Max Attempts -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Max Login Attempts</label>
                        <div class="relative">
                            <input type="number" name="login_max_attempts"
                                value="{{ $settings['login_max_attempts'] ?? 5 }}" min="1" max="50" required
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                            <span
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-xs font-medium text-gray-400">Attempts</span>
                        </div>
                        <p class="mt-2 text-xs text-gray-500">The number of times a user can attempt to log in before being
                            locked out.</p>
                        @error('login_max_attempts')
                            <p class="mt-1 text-xs text-red-500">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Decay Minutes -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Lockout Duration</label>
                        <div class="relative">
                            <input type="number" name="login_decay_minutes"
                                value="{{ $settings['login_decay_minutes'] ?? 1 }}" min="1" max="1440" required
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                            <span
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-xs font-medium text-gray-400">Minutes</span>
                        </div>
                        <p class="mt-2 text-xs text-gray-500">How many minutes the user must wait before attempting to log
                            in again after being locked out.</p>
                        @error('login_decay_minutes')
                            <p class="mt-1 text-xs text-red-500">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Dashboard Auto-Refresh Section -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden mb-6">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                    <h3 class="text-lg font-bold text-gray-800">Dashboard Auto-Refresh</h3>
                    <p class="text-gray-500 text-xs mt-1">Configure automatic refreshing of the dashboard to update schedule statuses.</p>
                </div>

                <div class="p-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Enable/Disable -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Enable Auto-Refresh</label>
                        <div class="flex items-center mt-2">
                             <input type="hidden" name="dashboard_refresh_enabled" value="0">
                             <input type="checkbox" name="dashboard_refresh_enabled" value="1" id="refresh_enabled"
                                    {{ isset($settings['dashboard_refresh_enabled']) && $settings['dashboard_refresh_enabled'] ? 'checked' : '' }}
                                    class="h-5 w-5 text-blue-600 focus:ring-blue-500 border-gray-300 rounded cursor-pointer transition-all">
                             <label for="refresh_enabled" class="ml-2 text-sm text-gray-700 font-medium cursor-pointer">
                                 Automatically refresh dashboard
                             </label>
                        </div>
                        <p class="mt-2 text-xs text-gray-500">If enabled, the dashboard will reload automatically to check for new schedule statuses (e.g. Missed, Completed).</p>
                    </div>

                    <!-- Interval -->
                    <div>
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Refresh Interval</label>
                        <div class="relative">
                            <input type="number" name="dashboard_refresh_interval"
                                value="{{ $settings['dashboard_refresh_interval'] ?? 5 }}" min="1" max="60"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                            <span
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-xs font-medium text-gray-400">Minutes</span>
                        </div>
                        <p class="mt-2 text-xs text-gray-500">How often the dashboard should refresh (in minutes).</p>
                        @error('dashboard_refresh_interval')
                            <p class="mt-1 text-xs text-red-500">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="flex justify-end">
                <button type="submit"
                    class="px-6 py-2 bg-blue-600 text-white text-sm font-bold rounded-md hover:bg-blue-700 transition-all shadow-sm flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    Save Changes
                </button>
            </div>
        </form>
    </div>
@endsection