@extends('layouts.admin')

@section('title', 'Command & Operational Protocols')

@section('content')
    <div class="p-6">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Operational Rules</h1>
            <p class="text-gray-500 text-sm mt-1">Standardize deployment timelines & financial logistics</p>
        </div>

        @if(session('success'))
            <div class="mb-6 p-4 bg-green-50 border border-green-100 text-green-700 rounded-lg flex items-center gap-3">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                {{ session('success') }}
            </div>
        @endif

        <form action="{{ route('admin.settings.operational.update') }}" method="POST" class="space-y-6">
            @csrf

            <!-- Section 1: Financial Logistics Baseline -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                    <h3 class="text-lg font-bold text-gray-800">Pay Protocol Baseline</h3>
                    <p class="text-gray-500 text-xs mt-1">Define organization-wide default wage types</p>
                </div>

                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($companies as $company)
                            <div class="p-4 rounded-lg border border-gray-200 bg-gray-50">
                                <div class="flex items-center gap-3 mb-4">
                                    <div
                                        class="w-8 h-8 rounded bg-white border border-gray-200 flex items-center justify-center text-xs font-bold text-gray-700">
                                        {{ substr($company->name, 0, 2) }}
                                    </div>
                                    <h4 class="font-bold text-gray-800 text-sm">{{ $company->name }}</h4>
                                </div>

                                <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Default Wage
                                    Type</label>
                                <select name="defaults[{{ $company->id }}][wage_type_id]"
                                    class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                                    <option value="">Select Protocol</option>
                                    @foreach($wageTypes as $type)
                                        <option value="{{ $type->id }}" {{ $company->default_wage_type_id == $type->id ? 'selected' : '' }}>{{ $type->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Section 2: Mission Intelligence & Disclosure -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                    <h3 class="text-lg font-bold text-gray-800">Mission Disclosure Matrix</h3>
                    <p class="text-gray-500 text-xs mt-1">Job visibility window (minutes before mission start)</p>
                </div>

                <div class="p-6 overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="border-b border-gray-100">
                                <th class="px-4 py-3 text-xs font-bold text-gray-500 uppercase tracking-wider text-left">
                                    Operational Unit</th>
                                @foreach($jobRoles as $role)
                                    <th class="px-4 py-3 text-xs font-bold text-gray-500 uppercase tracking-wider text-center">
                                        {{ $role->name }}
                                    </th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-50">
                            @foreach($companies as $company)
                                <tr class="hover:bg-gray-50/50">
                                    <td class="px-4 py-4">
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-8 h-8 rounded bg-gray-100 flex items-center justify-center text-xs font-bold text-gray-700">
                                                {{ substr($company->name, 0, 1) }}
                                            </div>
                                            <span class="font-bold text-gray-800 text-sm">{{ $company->name }}</span>
                                        </div>
                                    </td>
                                    @foreach($jobRoles as $role)
                                        @php
                                            $setting = $company->visibilitySettings->where('job_role_id', $role->id)->first();
                                        @endphp
                                        <td class="px-4 py-4">
                                            <div class="max-w-[100px] mx-auto relative group">
                                                <input type="number" name="visibility[{{ $company->id }}][{{ $role->id }}]"
                                                    value="{{ $setting ? $setting->visibility_minutes : '' }}" placeholder="0"
                                                    class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md text-center focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                                                <span
                                                    class="absolute right-2 top-1/2 -translate-y-1/2 text-xs text-gray-400 pointer-events-none">min</span>
                                            </div>
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Section 3: Time & Attendance -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                    <h3 class="text-lg font-bold text-gray-800">Attendance Protocol</h3>
                    <p class="text-gray-500 text-xs mt-1">Define thresholds for attendance monitoring</p>
                </div>

                <div class="p-6">
                    <div class="max-w-md">
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Late Check-in
                            Tolerance</label>
                        <div class="relative group">
                            <input type="number" name="late_checkin_tolerance" value="{{ $lateCheckinTolerance ?? 10 }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                            <span
                                class="absolute right-3 top-1/2 -translate-y-1/2 text-xs font-medium text-gray-500">MINUTES</span>
                        </div>
                        <p class="mt-2 text-xs text-gray-500">If an employee checks in this many minutes after start time,
                            it will be flagged as LATE.</p>
                    </div>
                </div>
            </div>

            <!-- Section 4: Notes Management -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                    <h3 class="text-lg font-bold text-gray-800">Mission Notes Protocol</h3>
                    <p class="text-gray-500 text-xs mt-1">Configure intervals for automated check-in notes</p>
                </div>

                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div>
                            <label class="flex items-center gap-3 cursor-pointer group">
                                <div class="relative">
                                    <input type="checkbox" name="notes_enabled" value="1" {{ $notesEnabled ? 'checked' : '' }} class="sr-only peer">
                                    <div
                                        class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600">
                                    </div>
                                </div>
                                <div>
                                    <span
                                        class="text-sm font-bold text-gray-700 group-hover:text-blue-600 transition-colors">Enable
                                        Automated Notes</span>
                                    <p class="text-[10px] text-gray-500 uppercase font-black tracking-widest mt-0.5">Global
                                        toggle for mission status notes</p>
                                </div>
                            </label>
                        </div>

                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Notes Recurring
                                Interval</label>
                            <div class="relative group">
                                <input type="number" name="notes_interval" value="{{ $notesInterval ?? 30 }}"
                                    class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                                <span
                                    class="absolute right-3 top-1/2 -translate-y-1/2 text-xs font-medium text-gray-500 uppercase tracking-tighter">Minutes</span>
                            </div>
                            <p class="mt-2 text-[10px] text-gray-500 font-bold uppercase tracking-widest">Sets how often the
                                system prompts or generates mission notes</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Section 5: Shift Duration Protocols -->
            <div class="bg-white rounded-lg shadow-sm border border-gray-100 overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100 bg-gray-50/50">
                    <h3 class="text-lg font-bold text-gray-800">Shift Duration & Overtime</h3>
                    <p class="text-gray-500 text-xs mt-1">Regulate mandatory caps and overtime triggers</p>
                </div>

                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Max Shift
                                Duration</label>
                            <div class="relative group">
                                <input type="number" step="0.5" name="max_shift_hours" value="{{ $maxShiftHours ?? 12 }}"
                                    class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                                <span
                                    class="absolute right-3 top-1/2 -translate-y-1/2 text-xs font-medium text-gray-500 uppercase tracking-tighter">Hours</span>
                            </div>
                            <p class="mt-2 text-[10px] text-gray-500 font-bold uppercase tracking-widest">Maximum hours
                                allowed for a single deployment</p>
                        </div>

                        <div>
                            <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Overtime
                                Threshold</label>
                            <div class="relative group">
                                <input type="number" step="0.5" name="overtime_threshold"
                                    value="{{ $overtimeThreshold ?? 8 }}"
                                    class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                                <span
                                    class="absolute right-3 top-1/2 -translate-y-1/2 text-xs font-medium text-gray-500 uppercase tracking-tighter">Hours</span>
                            </div>
                            <p class="mt-2 text-[10px] text-gray-500 font-bold uppercase tracking-widest">Hours beyond this
                                limit will be calculated as overtime</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Global Synchronization -->
            <div class="flex justify-end pt-4">
                <button type="submit"
                    class="px-6 py-2 bg-blue-600 text-white text-sm font-bold rounded-md hover:bg-blue-700 transition-all shadow-sm flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                    Save Changes
                </button>
            </div>
        </form>
    </div>
@endsection