@extends('layouts.admin')

@section('title', 'Create New Role')
@section('page_title', 'Access Control')

@section('content')
    <div class="max-w-4xl mx-auto">
        <div class="mb-6">
            <div class="flex items-center gap-2 text-sm text-gray-500 mb-2">
                <a href="{{ route('admin.roles.index') }}" class="hover:text-blue-600 transition-colors">Role
                    Architecture</a>
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <span class="text-gray-900 font-medium">Create</span>
            </div>
            <h1 class="text-2xl font-bold text-gray-800">Create New Role</h1>
            <p class="text-sm text-gray-500 mt-1">Define structural access tiers and functional bounds.</p>
        </div>

        <form action="{{ route('admin.roles.store') }}" method="POST">
            @csrf

            <div class="bg-white rounded-lg border border-gray-100 shadow-sm overflow-hidden mb-6">
                <!-- Role Name -->
                <div class="p-6 border-b border-gray-100">
                    <div class="max-w-md">
                        <label class="block text-xs font-semibold text-gray-500 uppercase mb-2">Role Designation <span
                                class="text-red-500">*</span></label>
                        <div class="relative group">
                            <input type="text" name="name" value="{{ old('name') }}" required
                                placeholder="e.g. SYSTEMS_OPERATOR"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all uppercase placeholder:normal-case">
                        </div>
                        @error('name')
                            <p class="mt-1 text-xs text-red-500">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Permissions -->
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <label class="block text-sm font-bold text-gray-800">Authorized Capabilities</label>
                        <span class="text-xs bg-blue-50 text-blue-600 px-2 py-1 rounded border border-blue-100">Select All
                            That Apply</span>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        @foreach($permissions as $permission)
                            <label
                                class="flex items-center gap-3 p-3 bg-gray-50 border border-gray-200 rounded-md cursor-pointer hover:bg-white hover:border-blue-300 transition-all select-none">
                                <input type="checkbox" name="permissions[]" value="{{ $permission->name }}"
                                    class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                                <span class="text-sm text-gray-700">{{ $permission->name }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                <div class="px-6 py-4 bg-gray-50 border-t border-gray-100 flex items-center justify-end gap-3">
                    <a href="{{ route('admin.roles.index') }}"
                        class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 font-bold hover:bg-white text-sm transition-all shadow-sm">Cancel</a>
                    <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-md font-bold hover:bg-blue-700 transition-all shadow-sm text-sm">Save
                        Role</button>
                </div>
            </div>
        </form>
    </div>
@endsection