@extends('layouts.admin')

@section('title', 'Edit Request Type')
@section('page_title', 'Edit Request Type')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Edit Request Type</h1>
        <p class="text-gray-500 text-sm">Update request type details.</p>
    </div>

    <div class="bg-white rounded-2xl border border-gray-100 shadow-sm p-6 max-w-2xl">
        <form action="{{ route('admin.request-types.update', $requestType) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="space-y-6">
                <div>
                    <label for="name" class="block text-sm font-bold text-gray-700 mb-2">Request Type Name</label>
                    <input type="text" name="name" id="name" value="{{ $requestType->name }}" required
                        class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none">
                </div>

                <div>
                    <label for="template" class="block text-sm font-bold text-gray-700 mb-2">
                        Additional Information / Message Template
                    </label>
                    <textarea name="template" id="template" rows="5"
                        class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:ring-4 focus:ring-blue-100 focus:border-blue-500 transition-all outline-none">{{ $requestType->template }}</textarea>
                </div>

                <div class="flex items-center gap-2">
                    <input type="checkbox" name="is_active" id="is_active" value="1" {{ $requestType->is_active ? 'checked' : '' }}
                        class="w-5 h-5 text-blue-600 rounded focus:ring-blue-500 border-gray-300">
                    <label for="is_active" class="text-sm font-bold text-gray-700">Active</label>
                </div>

                <div class="flex items-center gap-4 pt-4">
                    <button type="submit"
                        class="bg-blue-600 text-white px-6 py-3 rounded-xl font-bold hover:bg-blue-700 transition-all shadow-lg shadow-blue-200">
                        Update Request Type
                    </button>
                    <a href="{{ route('admin.request-types.index') }}"
                        class="text-gray-500 hover:text-gray-700 font-semibold px-4">
                        Cancel
                    </a>
                </div>
            </div>
        </form>
    </div>
@endsection
