@extends(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user')

@section('title', 'Ticket Reports')

@section('content')
    @php
        $routePrefix = request()->routeIs('admin.*') ? 'admin.reports.patroller' : 'reports.patroller';
    @endphp

    <div class="space-y-6">
        <!-- Navigation Tabs -->
        <div class="flex space-x-2 border-b border-gray-200 pb-2">
            <a href="{{ route($routePrefix . '.index') }}" 
               class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.index') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                In/Out Report
            </a>
            <a href="{{ route($routePrefix . '.tickets') }}" 
               class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Ticket Reports
            </a>
            <a href="{{ route($routePrefix . '.monthly_tickets') }}" 
               class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.monthly_tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Monthly Ticket Chart
            </a>
            <a href="{{ route($routePrefix . '.payout') }}" 
               class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Patroller Payout
            </a>
            <a href="{{ route($routePrefix . '.route_payout') }}" 
               class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.route_payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Route Payout
            </a>
            <a href="{{ route($routePrefix . '.route_margin') }}" 
               class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.route_margin') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Route Margin
            </a>
        </div>

        <!-- Filters -->
        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-200">
            <form method="GET" action="{{ route($routePrefix . '.tickets') }}" class="space-y-6">
                
                <div class="flex flex-col gap-6">
                    <!-- Date Presets -->
                    <div class="flex gap-2">
                        @php
                            $period = request('period', 'today');
                        @endphp
                        <button type="submit" name="period" value="today" class="px-3 py-1 text-xs font-bold rounded-full border {{ $period === 'today' ? 'bg-slate-900 text-white border-slate-900' : 'bg-white text-gray-600 border-gray-200 hover:border-gray-300' }}">Today</button>
                        <button type="submit" name="period" value="week" class="px-3 py-1 text-xs font-bold rounded-full border {{ $period === 'week' ? 'bg-slate-900 text-white border-slate-900' : 'bg-white text-gray-600 border-gray-200 hover:border-gray-300' }}">This Week</button>
                        <button type="submit" name="period" value="month" class="px-3 py-1 text-xs font-bold rounded-full border {{ $period === 'month' ? 'bg-slate-900 text-white border-slate-900' : 'bg-white text-gray-600 border-gray-200 hover:border-gray-300' }}">This Month</button>
                    </div>

                    <!-- Filters Row -->
                    <div class="flex flex-col md:flex-row gap-6">
                        <!-- Date Range -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Start Date</label>
                            <input type="date" name="start_date" value="{{ request('start_date') }}" 
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        </div>
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">End Date</label>
                            <input type="date" name="end_date" value="{{ request('end_date') }}" 
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        </div>

                        <!-- Route Filter -->
                        <div class="w-full md:w-40">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Route</label>
                            <select name="route_id" class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                                <option value="">All Routes</option>
                                @foreach($routes as $route)
                                    <option value="{{ $route->id }}" {{ request('route_id') == $route->id ? 'selected' : '' }}>
                                        {{ $route->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <!-- Site Filter -->
                        <div class="w-full md:w-40">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                            <select name="site_id" class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                                <option value="">All Sites</option>
                                @foreach($sites as $site)
                                    <option value="{{ $site->id }}" {{ request('site_id') == $site->id ? 'selected' : '' }}>
                                        {{ $site->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Ticket Type (Good/Bad) -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Type</label>
                            <select name="status" class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                                <option value="">All Types</option>
                                <option value="good" {{ request('status') == 'good' ? 'selected' : '' }}>Good Ticket</option>
                                <option value="bad" {{ request('status') == 'bad' ? 'selected' : '' }}>Bad Ticket</option>
                            </select>
                        </div>

                        <!-- Ticket Number Search -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Ticket #</label>
                            <input type="text" name="ticket_number" value="{{ request('ticket_number') }}" placeholder="T-123"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        </div>

                        <!-- Duty Number Search -->
                        <div class="w-full md:w-32">
                            <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Duty ID</label>
                            <input type="text" name="duty_number" value="{{ request('duty_number') }}" placeholder="P0001"
                                class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        </div>

                         <!-- Actions -->
                         <div class="flex items-end ml-auto gap-2">
                            <button type="submit" class="h-[38px] px-6 bg-purple-600 text-white text-sm font-medium rounded-lg hover:bg-purple-700 transition-colors shadow-sm">
                                Apply
                            </button>
                            
                            <div class="h-8 w-px bg-gray-200 mx-1"></div>

             <!-- Export Actions -->
            <div class="flex items-center gap-2">
                @php
                    $routePrefix = request()->routeIs('admin.*') ? 'admin.reports.patroller' : 'reports.patroller';
                @endphp
                <a href="{{ route($routePrefix . '.tickets.export.excel', request()->all()) }}" 
                   title="Export Excel"
                   class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-green-600 transition-colors shadow-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </a>
                <a href="javascript:void(0)" 
                   id="exportTicketsPdfBtn"
                   title="Export PDF"
                   class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-red-600 transition-colors shadow-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                    </svg>
                </a>
                <a href="{{ route($routePrefix . '.tickets.export.zip', request()->all()) }}" 
                   title="Download ZIP"
                   class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-purple-600 transition-colors shadow-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                    </svg>
                </a>
            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4">
                                <input type="checkbox" id="selectAll" class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Date</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Ticket #</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Duty ID</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider cursor-pointer group">
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'type', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="flex items-center gap-1 hover:text-gray-600">
                                    Type
                                    @if(request('sort') == 'type')
                                        <span class="text-xs">{{ request('direction') == 'asc' ? '▲' : '▼' }}</span>
                                    @endif
                                </a>
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider cursor-pointer group">
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'site', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="flex items-center gap-1 hover:text-gray-600">
                                    Site / Route
                                    @if(request('sort') == 'site')
                                        <span class="text-xs">{{ request('direction') == 'asc' ? '▲' : '▼' }}</span>
                                    @endif
                                </a>
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider cursor-pointer group">
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'patroller', 'direction' => request('direction') == 'asc' ? 'desc' : 'asc']) }}" class="flex items-center gap-1 hover:text-gray-600">
                                    Patroller
                                    @if(request('sort') == 'patroller')
                                        <span class="text-xs">{{ request('direction') == 'asc' ? '▲' : '▼' }}</span>
                                    @endif
                                </a>
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Description</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-right">Images</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($tickets as $ticket)
                            <tr class="hover:bg-gray-50/80 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <input type="checkbox" name="selected_ids[]" value="{{ $ticket->id }}" class="row-checkbox rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">
                                    {{ $ticket->created_at->format('M d, H:i') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-mono font-bold text-gray-900">
                                    {{ $ticket->ticket_number }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-xs font-mono text-purple-600 font-bold">
                                    #{{ $ticket->patrollerSchedule->duty_number ?? '-' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($ticket->status === 'good')
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold bg-green-100 text-green-700 uppercase tracking-wide">
                                            Good
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-bold bg-red-100 text-red-700 uppercase tracking-wide">
                                            Bad
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <div class="font-bold">{{ $ticket->site->name ?? '-' }}</div>
                                    <div class="text-xs text-gray-500">{{ $ticket->patrollerSchedule->route->name ?? '-' }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">
                                    {{ $ticket->employee->first_name ?? '' }} {{ $ticket->employee->last_name ?? '' }}
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-600 max-w-xs truncate" title="{{ $ticket->description }}">
                                    {{ Str::limit($ticket->description, 50) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right">
                                    @if(is_array($ticket->images) && count($ticket->images) > 0)
                                        <span class="inline-flex items-center gap-1 text-xs font-bold text-purple-600 bg-purple-50 border border-purple-100 px-2 py-1 rounded-lg">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                            {{ count($ticket->images) }}
                                        </span>
                                    @else
                                        <span class="text-xs text-gray-300">No img</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="px-6 py-12 text-center text-gray-400">
                                    <p class="text-xs font-bold uppercase tracking-wider">No tickets found</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if($tickets->hasPages())
                <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
                    {{ $tickets->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    
    <!-- Select2 JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Initialize Select2 for all filter dropdowns
            $('select[name="route_id"]').select2({
                placeholder: 'All Routes',
                allowClear: true,
                width: '100%'
            });
            
            $('select[name="site_id"]').select2({
                placeholder: 'All Sites',
                allowClear: true,
                width: '100%'
            });
            
            $('select[name="status"]').select2({
                placeholder: 'All Types',
                allowClear: true,
                width: '100%'
            });

            // Select All functionality
            $('#selectAll').on('change', function() {
                $('.row-checkbox').prop('checked', $(this).prop('checked'));
            });

            $('.row-checkbox').on('change', function() {
                if (!$(this).prop('checked')) $('#selectAll').prop('checked', false);
                if ($('.row-checkbox:checked').length === $('.row-checkbox').length) $('#selectAll').prop('checked', true);
            });

            // Handle Export PDF
            $('#exportTicketsPdfBtn').on('click', function() {
                let selectedIds = [];
                $('.row-checkbox:checked').each(function() {
                    selectedIds.push($(this).val());
                });

                let baseUrl = "{{ route($routePrefix . '.tickets.export.pdf') }}";
                let params = new URLSearchParams(window.location.search);
                if (selectedIds.length > 0) params.set('ids', selectedIds.join(','));
                window.location.href = baseUrl + '?' + params.toString();
            });
        });
    </script>
@endsection
