<!DOCTYPE html>
<html>

<head>
    <title>Route Margin Report</title>
    <style>
        body {
            font-family: sans-serif;
            font-size: 9px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 4px;
            text-align: left;
        }

        th {
            background: #f2f2f2;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .route-section {
            margin-bottom: 30px;
        }

        .text-right {
            text-align: right;
        }

        .text-green {
            color: green;
        }

        .text-red {
            color: red;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2>Route Margin Report</h2>
        <p>Period: {{ $startDate }} to {{ $endDate }}</p>
    </div>

    @foreach($marginData as $routeId => $data)
        <div class="route-section">
            <h3 style="margin-bottom: 5px;">{{ $data['route_name'] }}</h3>
            <table>
                <thead>
                    <tr>
                        <th>Employee</th>
                        <th>Duty #</th>
                        <th>Hours</th>
                        <th class="text-right">Route Total</th>
                        <th class="text-right">Total Cost</th>
                        <th class="text-right">Margin</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data['employees'] as $employee)
                        <tr>
                            <td>{{ $employee['employee_name'] }}</td>
                            <td>#{{ $employee['duty_number'] }}</td>
                            <td>{{ $employee['total_hours'] }}</td>
                            <td class="text-right">${{ number_format($employee['route_total'], 2) }}</td>
                            <td class="text-right">${{ number_format($employee['total_cost'], 2) }}</td>
                            <td class="text-right {{ $employee['margin'] >= 0 ? 'text-green' : 'text-red' }}">
                                ${{ number_format($employee['margin'], 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="font-weight: bold; background: #fafafa;">
                        <td colspan="2" class="text-right">Route Total:</td>
                        <td>{{ number_format($data['total_hours'], 2) }}</td>
                        <td class="text-right">${{ number_format($data['route_total'], 2) }}</td>
                        <td class="text-right">${{ number_format($data['total_cost'], 2) }}</td>
                        <td class="text-right {{ $data['total_margin'] >= 0 ? 'text-green' : 'text-red' }}">
                            ${{ number_format($data['total_margin'], 2) }}
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endforeach

</body>

</html>