@extends(request()->routeIs('admin.*') ? 'layouts.admin' : 'layouts.user')

@section('title', 'Ticket Monthly Report')

@section('content')
    @php
        $routePrefix = request()->routeIs('admin.*') ? 'admin.reports.patroller' : 'reports.patroller';
    @endphp

    <div class="space-y-6">
        <!-- Navigation Tabs -->
        <div class="flex space-x-2 border-b border-gray-200 pb-2 overflow-x-auto">
            <a href="{{ route($routePrefix . '.index') }}"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.index') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                In/Out Report
            </a>
            <a href="{{ route($routePrefix . '.tickets') }}"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Ticket Reports
            </a>
            <a href="{{ route($routePrefix . '.monthly_tickets') }}"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.monthly_tickets') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Monthly Ticket Chart
            </a>
            <a href="{{ route($routePrefix . '.payout') }}"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Patroller Payout
            </a>
            <a href="{{ route($routePrefix . '.route_payout') }}"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.route_payout') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Route Payout
            </a>
            <a href="{{ route($routePrefix . '.route_margin') }}"
                class="px-4 py-2 text-sm font-bold rounded-lg transition-colors {{ request()->routeIs($routePrefix . '.route_margin') ? 'bg-slate-900 text-white' : 'text-slate-600 hover:bg-gray-50' }}">
                Route Margin
            </a>
        </div>

        <!-- Filters -->
        <div class="bg-white p-6 rounded-lg shadow-sm border border-gray-200">
            <h2 class="text-2xl font-bold text-gray-800 mb-6">Ticket Monthly Report</h2>

            <form method="GET" action="{{ route($routePrefix . '.monthly_tickets') }}" class="flex items-end gap-4">
                <!-- Site Filter -->
                <div class="w-64">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Site</label>
                    <select name="site_id"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        <option value="">All Sites</option>
                        @foreach($sites as $site)
                            <option value="{{ $site->id }}" {{ request('site_id') == $site->id ? 'selected' : '' }}>
                                {{ $site->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Month Filter -->
                <div class="w-40">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Month</label>
                    <select name="month"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        @foreach(range(1, 12) as $m)
                            <option value="{{ $m }}" {{ request('month', now()->month) == $m ? 'selected' : '' }}>
                                {{ \Carbon\Carbon::create()->month($m)->format('F') }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Year Filter -->
                <div class="w-32">
                    <label class="block text-xs font-bold text-gray-600 mb-2 uppercase tracking-wide">Year</label>
                    <select name="year"
                        class="w-full text-sm rounded-lg border-gray-300 focus:border-purple-500 focus:ring-purple-500 px-3 py-2 shadow-sm">
                        @foreach(range(now()->year - 2, now()->year + 1) as $y)
                            <option value="{{ $y }}" {{ request('year', now()->year) == $y ? 'selected' : '' }}>
                                {{ $y }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <button type="submit"
                    class="h-[38px] px-6 bg-purple-600 text-white text-sm font-medium rounded-lg hover:bg-purple-700 transition-colors shadow-sm">
                    Apply
                </button>

                <div class="h-8 w-px bg-gray-200 mx-1"></div>

                <!-- Export Button -->
                <a href="{{ route($routePrefix . '.monthly_tickets.export', request()->all()) }}" title="Export Excel"
                    class="h-[38px] w-[38px] flex items-center justify-center bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 hover:text-green-600 transition-colors shadow-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                        </path>
                    </svg>
                </a>
            </form>
        </div>

        <!-- Data Table -->
        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th
                                class="px-4 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider sticky left-0 bg-gray-50 z-10">
                                Site</th>
                            @foreach($daysInMonth as $day)
                                <th class="px-3 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center">
                                    {{ $day }}
                                </th>
                            @endforeach
                            <th
                                class="px-4 py-3 text-[10px] font-bold text-gray-400 uppercase tracking-wider text-center bg-blue-50">
                                Total</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($reportData as $siteId => $siteData)
                            <tr class="hover:bg-gray-50/80 transition-colors">
                                <td class="px-4 py-3 text-sm font-bold text-gray-900 sticky left-0 bg-white whitespace-nowrap">
                                    {{ $siteData['name'] }}
                                </td>
                                @foreach($daysInMonth as $day)
                                    <td
                                        class="px-3 py-3 text-sm text-center {{ $siteData['days'][$day] > 0 ? 'text-gray-900 font-semibold' : 'text-gray-300' }}">
                                        {{ $siteData['days'][$day] }}
                                    </td>
                                @endforeach
                                <td class="px-4 py-3 text-sm font-bold text-center bg-blue-50 text-blue-700">
                                    {{ $siteData['total'] }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="{{ count($daysInMonth) + 2 }}" class="px-6 py-12 text-center text-gray-400">
                                    <p class="text-xs font-bold uppercase tracking-wider">No ticket data found for this period
                                    </p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection