<!DOCTYPE html>
<html>

<head>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 10px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        h2 {
            margin-bottom: 0px;
        }

        p {
            margin-top: 5px;
            color: #666;
            font-size: 12px;
        }

        .meta {
            margin-bottom: 20px;
        }
    </style>
</head>

<body>
    <div class="meta">
        @if($company)
            <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;">{{ $company->name }}</h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <h3 style="margin: 0; color: #334155;">Operational Report: {{ ucfirst($reportType) }}</h3>
        <p style="margin: 2px 0;">Generated By: {{ auth()->user()->name }}</p>
        <p style="margin: 2px 0;">Date Generated: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Duty #</th>
                <th>Employee</th>
                <th>Site</th>
                <th>Sched. In</th>
                <th>Sched. Out</th>
                <th>Act. In</th>
                <th>Act. Out</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($reports as $row)
                <tr>
                    <td>{{ \Carbon\Carbon::parse($row->schedule_date)->format('M d, Y') }}</td>
                    <td>{{ $row->duty_number }}</td>
                    <td>{{ $row->employee_name }}</td>
                    <td>{{ $row->site_name }}</td>
                    <td>{{ \Carbon\Carbon::parse($row->from_datetime)->format('H:i') }}</td>
                    <td>{{ \Carbon\Carbon::parse($row->to_datetime)->format('H:i') }}</td>
                    <td>
                        {{ $row->actual_start_at ? \Carbon\Carbon::parse($row->actual_start_at)->format('H:i') : '--' }}
                    </td>
                    <td>
                        {{ $row->actual_end_at ? \Carbon\Carbon::parse($row->actual_end_at)->format('H:i') : '--' }}
                    </td>
                    <td>{{ ucfirst($row->status) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>