<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Payout Summary Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 9px;
            margin: 15px;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #1e293b;
            padding-bottom: 10px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #1e293b;
        }

        .header p {
            margin: 5px 0;
            color: #64748b;
            font-size: 11px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }

        th {
            background-color: #1e293b;
            color: white;
            padding: 7px 5px;
            text-align: left;
            font-size: 7px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        th.text-right {
            text-align: right;
        }

        td {
            padding: 5px;
            border-bottom: 1px solid #e5e7eb;
            font-size: 8px;
            vertical-align: top;
        }

        td.text-right {
            text-align: right;
        }

        td.font-bold {
            font-weight: bold;
        }

        .wage-component {
            background-color: #eff6ff;
            border: 1px solid #bfdbfe;
            padding: 3px 5px;
            margin: 2px 0;
            border-radius: 3px;
            font-size: 7px;
        }

        .wage-component-name {
            color: #1e40af;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 6px;
        }

        .wage-component-calc {
            color: #64748b;
            font-size: 6px;
        }

        .wage-component-amount {
            color: #1e40af;
            font-weight: bold;
        }

        .gas-component {
            background-color: #fef3c7;
            border: 1px solid #fcd34d;
            padding: 3px 5px;
            margin: 2px 0;
            border-radius: 3px;
            font-size: 7px;
        }

        .gas-component-name {
            color: #b45309;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 6px;
        }

        .gas-component-amount {
            color: #b45309;
            font-weight: bold;
        }

        .no-wage {
            color: #9ca3af;
            font-style: italic;
            font-size: 7px;
        }

        .badge {
            display: inline-block;
            padding: 2px 5px;
            font-size: 6px;
            font-weight: bold;
            text-transform: uppercase;
            background-color: #e9d5ff;
            color: #7c3aed;
            border-radius: 3px;
            border: 1px solid #c084fc;
        }
    </style>
</head>

<body>
    <div style="margin-bottom: 20px;">
        @if($company)
            <div style="margin-bottom: 15px; border-bottom: 2px solid #1e293b; padding-bottom: 10px;">
                <h2 style="margin: 0; font-size: 20px; color: #1e293b; text-transform: uppercase;">{{ $company->name }}</h2>
                <p style="margin: 2px 0; font-size: 11px; color: #4b5563;">
                    {{ $company->address_1 }}{{ $company->address_2 ? ', ' . $company->address_2 : '' }}
                </p>
            </div>
        @endif
        <h3 style="margin: 0; color: #334155;">Payout Summary Report</h3>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Period:
            {{ \Carbon\Carbon::parse($startDate)->format('M d, Y') }} -
            {{ \Carbon\Carbon::parse($endDate)->format('M d, Y') }}
        </p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Generated By: {{ auth()->user()->name }}</p>
        <p style="margin: 2px 0; font-size: 10px; color: #64748b;">Date Generated: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Duty #</th>
                <th>Employee</th>
                <th>Site</th>
                <th>Site ID</th>
                @if(($calculationMode ?? 'actual') == 'scheduled')
                    <th>Sch. In</th>
                    <th>Sch. Out</th>
                    <th>Sch. Hrs</th>
                @else
                    <th>Act. In</th>
                    <th>Act. Out</th>
                    <th>Act. Hrs</th>
                @endif
                <th style="width: 30%;">Wage Components</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($payouts as $row)
                @php
                    $viewStart = $row->view_start ? \Carbon\Carbon::parse($row->view_start) : null;
                    $viewEnd = $row->view_end ? \Carbon\Carbon::parse($row->view_end) : null;
                    $viewHours = $row->view_hours ?? 0;

                    $wageTypes = json_decode($row->wage_types, true) ?: [];
                    $gasRate = $row->gas_rate > 0 ? $row->gas_rate : 0;
                @endphp

                <tr>
                    <td>{{ \Carbon\Carbon::parse($row->schedule_date)->format('Y-m-d') }}</td>
                    <td>{{ $row->duty_number }}</td>
                    <td class="font-bold">
                        {{ $row->first_name }} {{ $row->last_name }}
                        @if(isset($row->stat_multiplier) && $row->stat_multiplier > 1)
                            <span class="badge">STAT</span>
                        @endif
                    </td>
                    <td>{{ $row->site_name }}</td>
                    <td style="font-family: monospace; font-size: 7px;">{{ $row->site_custom_id }}</td>

                    <td>{{ $viewStart ? $viewStart->format('m/d H:i') : '--' }}</td>
                    <td>{{ $viewEnd ? $viewEnd->format('m/d H:i') : '--' }}</td>
                    <td class="font-bold">{{ number_format($viewHours, 2) }}</td>

                    <td>
                        @if(!empty($wageTypes) || $gasRate > 0)
                            @foreach($wageTypes as $wageType)
                                @php
                                    $componentHours = $wageType['allocated_hours'] ?? 0;
                                    $componentRate = $wageType['rate'] ?? 0;
                                    $componentPay = $componentHours * $componentRate;
                                @endphp
                                <div class="wage-component">
                                    <span class="wage-component-name">{{ $wageType['name'] ?? 'Wage' }}</span><br>
                                    <span class="wage-component-calc">{{ number_format($componentHours, 2) }} hrs ×
                                        ${{ number_format($componentRate, 2) }} = </span>
                                    <span class="wage-component-amount">${{ number_format($componentPay, 2) }}</span>
                                </div>
                            @endforeach

                            @if($gasRate > 0)
                                <div class="gas-component">
                                    <span class="gas-component-name">GAS/CASH</span><br>
                                    <span class="gas-component-amount">${{ number_format($gasRate, 2) }}</span>
                                </div>
                            @endif
                        @else
                            <span class="no-wage">No wage data</span>
                        @endif
                    </td>
                    <td class="text-right font-bold">${{ number_format($row->total_payout, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>