@forelse($employees as $employee)
    <tr class="hover:bg-gray-50/50 transition-all">
        <td class="px-6 py-4 text-sm font-bold text-gray-800">
            {{ $employee->first_name }} {{ $employee->last_name }}
        </td>
        <td class="px-6 py-4 text-xs font-medium text-gray-600">
            <div class="flex items-center gap-2 group" x-data="{ copied: false }">
                <span>{{ $employee->employee_id }}</span>
                @if($employee->employee_id)
                    <button type="button"
                        @click="navigator.clipboard.writeText('{{ $employee->employee_id }}'); copied = true; setTimeout(() => copied = false, 2000)"
                        class="text-gray-300 hover:text-blue-600 transition-colors opacity-0 group-hover:opacity-100 focus:outline-none"
                        title="Copy ID">
                        <svg x-show="!copied" class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 01-2-2V5a2 2 0 012-2h4.586">
                            </path>
                        </svg>
                        <svg x-show="copied" x-cloak class="w-4 h-4 text-emerald-500" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </button>
                @endif
            </div>
        </td>
        <td class="px-6 py-4 text-xs font-medium text-gray-600">
            <div class="flex items-center gap-2 group" x-data="{ copied: false }">
                <span>{{ $employee->email }}</span>
                @if($employee->email)
                    <button type="button"
                        @click="navigator.clipboard.writeText('{{ $employee->email }}'); copied = true; setTimeout(() => copied = false, 2000)"
                        class="text-gray-300 hover:text-blue-600 transition-colors opacity-0 group-hover:opacity-100 focus:outline-none"
                        title="Copy Email">
                        <svg x-show="!copied" class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7v8a2 2 0 002 2h6M8 7V5a2 2 0 012-2h4.586a1 1 0 01.707.293l4.414 4.414a1 1 0 01.293.707V15a2 2 0 01-2 2h-2M8 7H6a2 2 0 01-2-2V5a2 2 0 012-2h4.586">
                            </path>
                        </svg>
                        <svg x-show="copied" x-cloak class="w-4 h-4 text-emerald-500" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </button>
                @endif
            </div>
        </td>
        <td class="px-6 py-4">
            @php
                $allDays = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                $unavailable = $employee->unavailable_days ?? [];
                $available = array_diff($allDays, $unavailable);
            @endphp
            @if(count($available) === 7)
                <span class="px-2 py-1 text-xs font-bold text-emerald-700 bg-emerald-100 rounded-lg">All
                    Week</span>
            @elseif(empty($available))
                <span class="px-2 py-1 text-xs font-bold text-red-700 bg-red-100 rounded-lg">None</span>
            @else
                <div class="flex flex-wrap gap-1">
                    @foreach($available as $day)
                        <span class="px-2 py-1 text-[10px] font-medium text-slate-600 bg-slate-100 border border-slate-200 rounded">
                            {{ substr($day, 0, 3) }}
                        </span>
                    @endforeach
                </div>
            @endif
        </td>
    </tr>
@empty
    <tr>
        <td colspan="4" class="px-6 py-12 text-center text-gray-400">
            <p class="text-xs font-bold uppercase tracking-wider">No employees found</p>
        </td>
    </tr>
@endforelse