@extends('layouts.admin')

@section('title', 'Edit ID Setting')
@section('page_title', 'Edit ID Setting')

@section('content')
    <div class="max-w-6xl mx-auto">
        <div class="mb-6">
            <div class="flex items-center gap-2 text-sm text-gray-400 mb-2">
                <a href="{{ route('admin.id-settings.index') }}" class="hover:text-blue-600 transition-colors">Id
                    Settings</a>
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <span class="text-gray-900 font-medium">Edit</span>
            </div>
            <h1 class="text-2xl font-bold text-gray-800">Edit Id Setting</h1>
        </div>

        <form action="{{ route('admin.id-settings.update', $idSetting) }}" method="POST">
            @csrf
            @method('PUT')

            <!-- Select Company Block -->
            <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm mb-6">
                <h3 class="text-sm font-bold text-gray-800 mb-4 flex items-center gap-2">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    Select Company
                </h3>
                <div class="max-w-md">
                    <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Company <span
                            class="text-red-500">*</span></label>
                    <select name="company_id" required
                        class="w-full px-3 py-2 text-sm bg-gray-50 border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all appearance-none cursor-not-allowed"
                        disabled>
                        @foreach($companies as $company)
                            <option value="{{ $company->id }}" {{ $idSetting->company_id == $company->id ? 'selected' : '' }}>
                                {{ $company->name }}
                            </option>
                        @endforeach
                    </select>
                    <input type="hidden" name="company_id" value="{{ $idSetting->company_id }}">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <!-- Emp ID Settings -->
                <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                    <h3 class="text-sm font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        Emp ID
                    </h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Prefix
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="emp_prefix" placeholder="Prefix"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all"
                                value="{{ $idSetting->emp_prefix }}">
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Next
                                Number <span class="text-red-500">*</span></label>
                            <input type="number" name="emp_next_number" value="{{ $idSetting->emp_next_number }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                    </div>
                </div>

                <!-- Site ID Settings -->
                <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                    <h3 class="text-sm font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        Site ID
                    </h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Prefix
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="site_prefix" placeholder="Prefix"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all"
                                value="{{ $idSetting->site_prefix }}">
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Next
                                Number <span class="text-red-500">*</span></label>
                            <input type="number" name="site_next_number" value="{{ $idSetting->site_next_number }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                    </div>
                </div>

                <!-- Route ID Settings -->
                <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                    <h3 class="text-sm font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        Route ID
                    </h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Prefix
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="route_prefix" placeholder="Prefix"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all"
                                value="{{ $idSetting->route_prefix }}">
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Next
                                Number <span class="text-red-500">*</span></label>
                            <input type="number" name="route_next_number" value="{{ $idSetting->route_next_number }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                    </div>
                </div>

                <!-- Duty ID Settings -->
                <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                    <h3 class="text-sm font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        Duty ID
                    </h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Prefix
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="duty_prefix" placeholder="Prefix"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all"
                                value="{{ $idSetting->duty_prefix }}">
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Next
                                Number <span class="text-red-500">*</span></label>
                            <input type="number" name="duty_next_number" value="{{ $idSetting->duty_next_number }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                    </div>
                </div>

                <!-- Incident ID Settings -->
                <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                    <h3 class="text-sm font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        Incident ID
                    </h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Prefix
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="incident_prefix" placeholder="Prefix"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all"
                                value="{{ $idSetting->incident_prefix }}">
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Next
                                Number <span class="text-red-500">*</span></label>
                            <input type="number" name="incident_next_number" value="{{ $idSetting->incident_next_number }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                    </div>
                </div>

                <!-- Patroller ID Settings -->
                <div class="bg-white p-6 rounded-lg border border-gray-100 shadow-sm">
                    <h3 class="text-sm font-bold text-gray-800 mb-4 flex items-center gap-2">
                        <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                        Patroller ID
                    </h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Prefix
                                <span class="text-red-500">*</span></label>
                            <input type="text" name="patroller_prefix" placeholder="Prefix"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all"
                                value="{{ $idSetting->patroller_prefix ?? 'P' }}">
                        </div>
                        <div>
                            <label class="text-xs font-semibold text-gray-500 uppercase tracking-wider mb-2 block">Next
                                Number <span class="text-red-500">*</span></label>
                            <input type="number" name="patroller_next_number"
                                value="{{ $idSetting->patroller_next_number ?? 1 }}"
                                class="w-full px-3 py-2 text-sm border border-gray-200 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all">
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex justify-end gap-3">
                <a href="{{ route('admin.id-settings.index') }}"
                    class="px-4 py-2 rounded-md border border-gray-300 text-gray-700 font-bold hover:bg-white text-sm transition-all shadow-sm">Cancel</a>
                <button type="submit"
                    class="px-6 py-2 bg-blue-600 text-white rounded-md font-bold hover:bg-blue-700 transition-all shadow-sm">Update
                    ID Settings</button>
            </div>
        </form>
    </div>
@endsection