@extends('layouts.user')

@section('title', 'Request Details')

@section('content')
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header Section -->
        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-8">
            <div>
                <h1 class="text-3xl font-extrabold text-slate-900 tracking-tight">Request Review</h1>
                <p class="text-sm text-slate-500 mt-1 font-medium">Manage and respond to employee inquiries</p>
            </div>
            <a href="{{ route('employee-requests.index') }}"
                class="inline-flex items-center justify-center px-4 py-2 bg-white border border-slate-200 rounded-lg text-sm font-bold text-slate-700 hover:bg-slate-50 hover:text-slate-900 transition-all shadow-sm group">
                <svg class="w-4 h-4 mr-2 text-slate-400 group-hover:text-slate-600 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Requests
            </a>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Left Column: Conversation -->
            <div class="lg:col-span-2 flex flex-col h-full space-y-6">
                
                <!-- Chat Container -->
                <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden flex flex-col h-[600px]">
                    <!-- Chat Header -->
                    <div class="px-6 py-4 border-b border-slate-100 bg-slate-50/50 flex items-center justify-between">
                        <div class="flex items-center gap-2">
                             <div class="w-2 h-2 rounded-full bg-emerald-500 animate-pulse"></div>
                             <span class="text-xs font-bold text-slate-500 uppercase tracking-wider">Live Discussion</span>
                        </div>
                    </div>

                    <!-- Chat Messages -->
                    <div class="flex-1 p-6 overflow-y-auto space-y-6 bg-slate-50/30 scroll-smooth">
                        <!-- Initial Request -->
                        <div class="flex justify-start">
                            <div class="max-w-[85%]">
                                <div class="flex items-end gap-2 mb-1">
                                    <span class="text-xs font-bold text-slate-600 ml-1">{{ $employeeRequest->employee->first_name }}</span>
                                    <span class="text-[10px] text-slate-400">{{ $employeeRequest->created_at->format('M d, H:i') }}</span>
                                </div>
                                <div class="bg-white border border-slate-200 text-slate-800 rounded-2xl rounded-tl-none px-6 py-5 shadow-sm relative group">
                                     @if($employeeRequest->subject)
                                        <h3 class="font-bold text-lg text-slate-900 mb-2 leading-tight">{{ $employeeRequest->subject }}</h3>
                                    @endif
                                    <p class="text-sm leading-relaxed text-slate-600 whitespace-pre-wrap">{{ $employeeRequest->message }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Replies -->
                        @foreach($employeeRequest->replies as $reply)
                            <div class="flex {{ $reply->is_employee_reply ? 'justify-start' : 'justify-end' }}">
                                <div class="max-w-[85%]">
                                    <div class="flex items-end gap-2 mb-1 {{ $reply->is_employee_reply ? 'justify-start' : 'justify-end' }}">
                                        @if(!$reply->is_employee_reply)
                                            <span class="text-[10px] text-slate-400 order-1">{{ $reply->created_at->format('M d, H:i') }}</span>
                                            <span class="text-xs font-bold text-slate-600 mr-1 order-2">You</span>
                                        @else
                                            <span class="text-xs font-bold text-slate-600 ml-1">{{ $employeeRequest->employee->first_name }}</span>
                                            <span class="text-[10px] text-slate-400">{{ $reply->created_at->format('M d, H:i') }}</span>
                                        @endif
                                    </div>
                                    
                                    <div class="{{ $reply->is_employee_reply ? 'bg-white border border-slate-200 text-slate-800 rounded-tl-none' : 'bg-slate-900 text-white rounded-tr-none' }} rounded-2xl px-6 py-4 shadow-sm relative">
                                        <p class="text-sm leading-relaxed whitespace-pre-wrap {{ $reply->is_employee_reply ? 'text-slate-600' : 'text-slate-200' }}">{{ $reply->message }}</p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Reply Input -->
                    <div class="p-4 bg-white border-t border-slate-100">
                        <form action="{{ route('employee-requests.reply', $employeeRequest) }}" method="POST">
                            @csrf
                            <div class="relative group">
                                <textarea name="message" rows="3"
                                    class="w-full bg-slate-50 border-slate-200 rounded-xl px-4 py-3 text-sm font-medium text-slate-800 placeholder-slate-400 focus:ring-2 focus:ring-slate-900 focus:border-transparent focus:bg-white transition-all resize-none shadow-inner"
                                    placeholder="Type a professional reply..." required></textarea>
                                <button type="submit"
                                    class="absolute bottom-3 right-3 px-4 py-2 bg-slate-900 text-white text-xs font-bold uppercase tracking-wider rounded-lg shadow-sm hover:bg-black transition-all transform active:scale-95 flex items-center gap-2">
                                    <span>Send Reply</span>
                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"></path>
                                    </svg>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Right Column: Sidebar Info -->
            <div class="space-y-6">
                <!-- Info Card -->
                <div class="bg-white p-6 rounded-2xl border border-slate-200 shadow-sm sticky top-6">
                    <div class="flex items-center justify-between mb-6">
                         <h3 class="font-bold text-slate-900 text-base uppercase tracking-tight">Request Details</h3>
                         <span class="px-2 py-1 rounded bg-slate-100 text-slate-500 text-[10px] font-mono font-bold">#{{ $employeeRequest->id }}</span>
                    </div>

                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 rounded-xl bg-slate-100 flex items-center justify-center text-slate-700 font-bold text-xl border border-slate-200">
                            {{ substr($employeeRequest->employee->first_name, 0, 1) }}
                        </div>
                        <div>
                            <p class="font-bold text-slate-900 text-base">{{ $employeeRequest->employee->first_name }} {{ $employeeRequest->employee->last_name }}</p>
                            <div class="flex items-center gap-2 mt-0.5">
                                <span class="px-1.5 py-0.5 rounded bg-slate-100 text-slate-500 text-[10px] font-bold uppercase">ID: {{ $employeeRequest->employee->id }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-5">
                        <div class="pb-5 border-b border-slate-100">
                            <label class="text-[10px] text-slate-400 font-bold uppercase tracking-widest mb-1 block">Category</label>
                            <div class="flex items-center gap-2">
                                <span class="w-2 h-2 rounded-full bg-indigo-500"></span>
                                <p class="font-bold text-slate-700 text-sm">{{ ucfirst($employeeRequest->type) }}</p>
                            </div>
                        </div>

                        <div class="pb-5 border-b border-slate-100">
                            <label class="text-[10px] text-slate-400 font-bold uppercase tracking-widest mb-1 block">Timeline</label>
                            <div class="flex flex-col gap-1">
                                <p class="text-xs font-medium text-slate-600">Submitted: <span class="text-slate-900">{{ $employeeRequest->created_at->format('M d, Y') }}</span></p>
                                <p class="text-xs font-medium text-slate-400">{{ $employeeRequest->created_at->diffForHumans() }}</p>
                            </div>
                        </div>

                        <div>
                            <label class="text-[10px] text-slate-400 font-bold uppercase tracking-widest mb-3 block">Current Status</label>
                            <form action="{{ route('employee-requests.status', $employeeRequest) }}" method="POST">
                                @csrf @method('PATCH')
                                <div class="relative">
                                    <select name="status"
                                        class="w-full appearance-none bg-slate-50 border border-slate-200 text-slate-700 text-sm font-bold rounded-xl px-4 py-3 pr-8 focus:outline-none focus:ring-2 focus:ring-slate-900 focus:border-transparent transition-shadow cursor-pointer"
                                        onchange="this.form.submit()">
                                        <option value="pending" {{ $employeeRequest->status == 'pending' ? 'selected' : '' }}>Pending Review</option>
                                        <option value="replied" {{ $employeeRequest->status == 'replied' ? 'selected' : '' }}>Replied</option>
                                        <option value="approved" {{ $employeeRequest->status == 'approved' ? 'selected' : '' }}>Approved</option>
                                        <option value="rejected" {{ $employeeRequest->status == 'rejected' ? 'selected' : '' }}>Rejected</option>
                                    </select>
                                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-4 text-slate-500">
                                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                                        </svg>
                                    </div>
                                </div>
                            </form>
                            
                            <!-- Visual Status Indicator -->
                            <div class="mt-4 flex items-center justify-center">
                                @php
                                    $statusColors = [
                                        'pending' => 'bg-amber-100 text-amber-700',
                                        'replied' => 'bg-blue-100 text-blue-700',
                                        'approved' => 'bg-emerald-100 text-emerald-700',
                                        'rejected' => 'bg-red-100 text-red-700',
                                    ];
                                    $currentStatusColor = $statusColors[$employeeRequest->status] ?? 'bg-gray-100 text-gray-700';
                                @endphp
                                <span class="px-3 py-1 rounded-full text-[10px] font-bold uppercase tracking-wider {{ $currentStatusColor }}">
                                    {{ ucfirst($employeeRequest->status) }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection