@extends('layouts.user')

@section('title', 'Employee Requests')

@section('content')
    <div class="mb-6 flex items-center justify-between">
        <h1 class="text-2xl font-bold text-gray-900">Employee Requests</h1>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead class="bg-gray-50 border-b border-gray-100">
                <tr>
                    <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider">Employee</th>
                    <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider">Type</th>
                    <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider">Subject</th>
                    <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                @forelse($requests as $req)
                    <tr class="hover:bg-gray-50 transition-colors cursor-pointer"
                        onclick="window.location='{{ route('employee-requests.show', $req) }}'">
                        <td class="px-6 py-4">
                            <div class="text-sm font-bold text-gray-900">{{ $req->employee->first_name }}
                                {{ $req->employee->last_name }}</div>
                            <div class="text-xs text-gray-400">ID: {{ $req->employee->employee_id ?? $req->employee->id }}
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span
                                class="px-2 py-1 bg-gray-100 text-gray-600 text-[10px] font-bold rounded uppercase tracking-wide">{{ ucfirst($req->type) }}</span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $req->subject ?: 'No Subject' }}</td>
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 rounded-full text-[10px] font-bold uppercase tracking-wide
                                        @if($req->status == 'pending') bg-amber-100 text-amber-700
                                        @elseif($req->status == 'replied') bg-blue-100 text-blue-700
                                        @elseif($req->status == 'approved') bg-emerald-100 text-emerald-700
                                        @elseif($req->status == 'rejected') bg-rose-100 text-rose-700
                                        @endif
                                    ">
                                {{ ucfirst($req->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-xs text-gray-500">{{ $req->created_at->format('M d, Y') }}</td>
                        <td class="px-6 py-4 text-right">
                            <a href="{{ route('employee-requests.show', $req) }}"
                                class="text-blue-600 font-bold text-xs hover:underline">View</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="p-8 text-center text-gray-500 italic">No requests found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="mt-4">{{ $requests->links() }}</div>
@endsection