@extends('layouts.admin')

@section('title', 'Admin - Email Templates')

@section('content')
    <div class="mb-6 flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Email Templates</h1>
            <p class="text-gray-500 text-sm">Manage custom email templates per company.</p>
        </div>
        <div class="flex flex-wrap items-center gap-3">
             <a href="{{ route('admin.email-templates.create') }}" class="px-6 py-2.5 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-md shadow-blue-500/20 flex items-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                </svg>
                Create Template
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="mb-6 p-4 bg-emerald-50 border border-emerald-100 text-emerald-700 rounded-xl flex items-center gap-3">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
            </svg>
            {{ session('success') }}
        </div>
    @endif

    <!-- Filters & Search -->
    <div class="bg-white p-4 rounded-2xl shadow-sm border border-gray-100 mb-6">
        <form action="{{ route('admin.email-templates.index') }}" method="GET" class="flex flex-wrap items-center gap-4">
            <div class="flex-1 min-w-[300px]">
                <label class="block text-[10px] font-bold text-gray-400 uppercase mb-1">Search Template</label>
                <div class="relative">
                    <input type="text" name="search" value="{{ request('search') }}" placeholder="Search by name or subject..." class="w-full pl-10 pr-4 py-2.5 text-sm border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none transition-all">
                    <svg class="w-4 h-4 absolute left-3 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                </div>
            </div>
            <div class="w-64">
                <label class="block text-[10px] font-bold text-gray-400 uppercase mb-1">Filter by Company</label>
                <select name="company_id" class="w-full px-3 py-2.5 text-sm border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none" onchange="this.form.submit()">
                    <option value="">All Companies</option>
                    @foreach($companies as $company)
                        <option value="{{ $company->id }}" {{ request('company_id') == $company->id ? 'selected' : '' }}>{{ $company->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end h-full pt-6">
                <button type="submit" class="px-6 py-2.5 bg-slate-800 text-white text-sm font-bold rounded-xl hover:bg-slate-900 transition-all">Apply</button>
                @if(request('company_id') || request('search'))
                    <a href="{{ route('admin.email-templates.index') }}" class="ml-2 px-6 py-2.5 bg-gray-100 text-gray-600 text-sm font-bold rounded-xl hover:bg-gray-200 transition-all">Reset</a>
                @endif
            </div>
        </form>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">
        <table class="w-full text-left border-collapse">
            <thead class="bg-[#1e293b]">
                <tr>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Company</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Template Details</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Subject</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Attachment</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider">Status</th>
                    <th class="px-6 py-4 text-xs font-bold text-white uppercase tracking-wider text-right">Actions</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-50">
                @forelse($templates as $template)
                    <tr class="hover:bg-gray-50/50 transition-colors">
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 bg-blue-50 text-blue-700 text-[10px] font-bold rounded uppercase tracking-tighter">{{ $template->company->name }}</span>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm font-bold text-gray-900">{{ $template->name }}</div>
                            <div class="text-[10px] text-gray-400 max-w-xs truncate">{{ $template->description }}</div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="text-sm text-gray-600">{{ $template->subject }}</div>
                        </td>
                        <td class="px-6 py-4">
                            @if($template->attachment)
                                <a href="{{ Storage::url($template->attachment) }}" target="_blank" class="flex items-center gap-1 text-[10px] text-blue-600 font-bold hover:underline">
                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.414 6.586a6 6 0 108.486 8.486L20.5 13"></path>
                                    </svg>
                                    View File
                                </a>
                            @else
                                <span class="text-[10px] text-gray-300">None</span>
                            @endif
                        </td>
                        <td class="px-6 py-4">
                            @if($template->is_active)
                                <span class="px-2 py-1 bg-emerald-100 text-emerald-700 text-[10px] font-bold rounded-full uppercase tracking-tighter">Active</span>
                            @else
                                <span class="px-2 py-1 bg-rose-100 text-rose-700 text-[10px] font-bold rounded-full uppercase tracking-tighter">Disabled</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-right">
                            <div class="flex justify-end items-center gap-2">
                                <a href="{{ route('admin.email-templates.edit', $template) }}" class="p-2 text-blue-600 hover:bg-blue-50 rounded-lg transition-all" title="Edit">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                    </svg>
                                </a>
                                <button type="button" 
                                    onclick="openSendModal('{{ route('admin.email-templates.send', $template) }}', '{{ $template->name }}')"
                                    class="p-2 text-indigo-600 hover:bg-indigo-50 rounded-lg transition-all"
                                    title="Send Email">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                    </svg>
                                </button>
                                <button type="button"
                                    onclick="openDeleteModal('{{ route('admin.email-templates.destroy', $template) }}', '{{ $template->name }}')"
                                    class="p-2 text-red-600 hover:bg-red-50 rounded-lg transition-all"
                                    title="Delete">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                    </svg>
                                </button>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center text-gray-500 italic">
                            No templates found. Click "Create Template" to get started.
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    
    <div class="mt-6">
        {{ $templates->links() }}
    </div>

    <!-- Send Email Modal -->
    <div id="sendEmailModal" class="fixed inset-0 z-50 hidden overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true" onclick="closeSendModal()"></div>

            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <div class="inline-block align-bottom bg-white rounded-2xl text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                <form id="sendEmailForm" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-blue-100 sm:mx-0 sm:h-10 sm:w-10">
                                <svg class="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                    Send "<span id="sendTemplateName"></span>"
                                </h3>
                                
                                <div class="mt-4">
                                    <!-- Tabs -->
                                    <div class="flex border-b border-gray-200 mb-4">
                                        <button type="button" onclick="switchTab('employees')" id="tab-btn-employees" class="tab-btn w-1/3 py-2 px-1 text-center border-b-2 font-medium text-sm border-blue-500 text-blue-600">
                                            Employees
                                        </button>
                                        <button type="button" onclick="switchTab('sites')" id="tab-btn-sites" class="tab-btn w-1/3 py-2 px-1 text-center border-b-2 font-medium text-sm border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300">
                                            Sites
                                        </button>
                                        <button type="button" onclick="switchTab('custom')" id="tab-btn-custom" class="tab-btn w-1/3 py-2 px-1 text-center border-b-2 font-medium text-sm border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300">
                                            Import
                                        </button>
                                    </div>

                                    <input type="hidden" name="target_audience" id="targetAudienceInput" value="employees">

                                    <!-- Employees Tab -->
                                    <div id="tab-content-employees" class="tab-content">
                                        <div class="mb-2">
                                            <input type="text" id="employeeSearch" placeholder="Search employees..." class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm text-sm focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div class="h-48 overflow-y-auto border border-gray-200 rounded-md p-2 space-y-1" id="employeeList">
                                            <label class="flex items-center space-x-2 p-1 hover:bg-gray-50 rounded cursor-pointer">
                                                 <input type="checkbox" onchange="toggleAllCheckboxes(this, 'employeeList')" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                                 <span class="text-xs font-bold text-gray-700">Select All</span>
                                            </label>
                                            @foreach($employees as $employee)
                                                @if($employee->email)
                                                    <label class="flex items-center space-x-2 p-1 hover:bg-gray-50 rounded cursor-pointer searchable-item">
                                                        <input type="checkbox" name="employee_ids[]" value="{{ $employee->id }}" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                                        <span class="text-xs text-gray-700">{{ $employee->first_name }} {{ $employee->last_name }} <span class="text-gray-400">({{ $employee->email }})</span></span>
                                                    </label>
                                                @endif
                                            @endforeach
                                        </div>
                                    </div>

                                    <!-- Sites Tab -->
                                    <div id="tab-content-sites" class="tab-content hidden">
                                        <div class="mb-2">
                                            <input type="text" id="siteSearch" placeholder="Search sites..." class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm text-sm focus:ring-blue-500 focus:border-blue-500">
                                        </div>
                                        <div class="h-48 overflow-y-auto border border-gray-200 rounded-md p-2 space-y-1" id="siteList">
                                            <label class="flex items-center space-x-2 p-1 hover:bg-gray-50 rounded cursor-pointer">
                                                 <input type="checkbox" onchange="toggleAllCheckboxes(this, 'siteList')" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                                 <span class="text-xs font-bold text-gray-700">Select All</span>
                                            </label>
                                            @foreach($sites as $site)
                                                @if($site->contact_email)
                                                    <label class="flex items-center space-x-2 p-1 hover:bg-gray-50 rounded cursor-pointer searchable-item">
                                                        <input type="checkbox" name="site_ids[]" value="{{ $site->id }}" class="rounded border-gray-300 text-blue-600 focus:ring-blue-500">
                                                        <span class="text-xs text-gray-700">{{ $site->name }} <span class="text-gray-400">({{ $site->contact_email }})</span></span>
                                                    </label>
                                                @endif
                                            @endforeach
                                        </div>
                                    </div>

                                    <!-- Import Tab -->
                                    <div id="tab-content-custom" class="tab-content hidden">
                                        <div class="mt-2">
                                            <label class="block text-sm font-medium text-gray-700 mb-2">Upload Excel File</label>
                                            <div class="flex items-center justify-center w-full">
                                                <label class="flex flex-col items-center justify-center w-full h-32 border-2 border-dashed border-gray-300 rounded-lg cursor-pointer bg-gray-50 hover:bg-gray-100">
                                                    <div class="flex flex-col items-center justify-center pt-5 pb-6">
                                                        <svg class="w-8 h-8 mb-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path></svg>
                                                        <p class="mb-2 text-sm text-gray-500"><span class="font-semibold">Click to upload</span> or drag and drop</p>
                                                        <p class="text-xs text-gray-500">XLSX, XLS or CSV</p>
                                                    </div>
                                                    <input type="file" name="excel_file" class="hidden" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel">
                                                </label>
                                            </div>
                                            <p class="mt-2 text-xs text-gray-500">The file should contain a column named "email" or have emails in the first column.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="submit" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm">
                            Send Emails
                        </button>
                        <button type="button" onclick="closeSendModal()" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            Cancel
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Delete Modal (Existing) -->
    <!-- ... (Assuming delete modal is handled elsewhere or via similar js, adding JS below) ... -->

    <script>
        function openDeleteModal(url, name) {
            if(confirm('Are you sure you want to delete template "' + name + '"?')) {
                var form = document.createElement('form');
                form.action = url;
                form.method = 'POST';
                form.innerHTML = '@csrf @method("DELETE")';
                document.body.appendChild(form);
                form.submit();
            }
        }

        function openSendModal(url, name) {
            document.getElementById('sendEmailForm').action = url;
            document.getElementById('sendTemplateName').innerText = name;
            document.getElementById('sendEmailModal').classList.remove('hidden');
        }

        function closeSendModal() {
            document.getElementById('sendEmailModal').classList.add('hidden');
        }

        function switchTab(tabName) {
            // Update hidden input
            document.getElementById('targetAudienceInput').value = tabName;

            // Update Tab Buttons
            var buttons = document.getElementsByClassName('tab-btn');
            for(var i=0; i<buttons.length; i++) {
                buttons[i].classList.remove('border-blue-500', 'text-blue-600');
                buttons[i].classList.add('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
            }
            var activeBtn = document.getElementById('tab-btn-' + tabName);
            activeBtn.classList.remove('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
            activeBtn.classList.add('border-blue-500', 'text-blue-600');

            // Update Tab Content
            var contents = document.getElementsByClassName('tab-content');
            for(var i=0; i<contents.length; i++) {
                contents[i].classList.add('hidden');
            }
            document.getElementById('tab-content-' + tabName).classList.remove('hidden');
        }

        function toggleAllCheckboxes(source, containerId) {
            var checkboxes = document.querySelectorAll('#' + containerId + ' input[type="checkbox"]');
            for(var i=0, n=checkboxes.length;i<n;i++) {
                // Determine if visible
                var label = checkboxes[i].closest('label');
                if(label.style.display !== 'none') {
                    checkboxes[i].checked = source.checked;
                }
            }
        }

        // Simple search filter
        function setupSearch(inputId, listId) {
            document.getElementById(inputId).addEventListener('keyup', function() {
                var filter = this.value.toLowerCase();
                var list = document.getElementById(listId);
                var items = list.getElementsByClassName('searchable-item');
                for (var i = 0; i < items.length; i++) {
                    var txtValue = items[i].textContent || items[i].innerText;
                    if (txtValue.toLowerCase().indexOf(filter) > -1) {
                         items[i].style.display = "";
                    } else {
                         items[i].style.display = "none";
                    }
                }
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            setupSearch('employeeSearch', 'employeeList');
            setupSearch('siteSearch', 'siteList');
        });
    </script>
