@extends('layouts.admin')

@section('title', 'Admin - Create Email Template')

@section('content')
    <!-- Breadcrumb & Header -->
    <div
        class="flex flex-col md:flex-row md:items-center justify-between gap-4 bg-slate-900 p-8 rounded-[2rem] text-white shadow-2xl mb-6">
        <div>
            <div class="flex items-center gap-2 text-[10px] font-bold uppercase tracking-widest text-blue-400 mb-1">
                <a href="{{ route('admin.email-templates.index') }}" class="hover:text-white transition-colors">Email
                    Templates</a>
                <svg class="w-3 h-3 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <span class="text-white">Create New</span>
            </div>
            <h1 class="text-3xl font-black tracking-tight">Create Email Template</h1>
            <p class="text-xs text-slate-400 font-medium mt-1">Define a new email template with custom content and
                attachments.</p>
        </div>
        <a href="{{ route('admin.email-templates.index') }}"
            class="flex items-center gap-2 px-6 py-2.5 bg-white/10 hover:bg-white/20 text-white text-xs font-bold rounded-2xl backdrop-blur-md transition-all border border-white/10">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18">
                </path>
            </svg>
            Back to List
        </a>
    </div>

    <div class="bg-white border border-slate-100 rounded-[2rem] shadow-2xl overflow-hidden">
        <form action="{{ route('admin.email-templates.store') }}" method="POST" enctype="multipart/form-data"
            class="p-10 space-y-8">
            @csrf

            <!-- Basic Information Section -->
            <div>
                <div class="flex items-center gap-2 mb-6">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Basic Information</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Company
                            <span class="text-red-500 ml-1">*</span></label>
                        <select name="company_id" required
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all cursor-pointer text-sm">
                            <option value="">Select Company</option>
                            @foreach($companies as $company)
                                <option value="{{ $company->id }}" {{ old('company_id') == $company->id ? 'selected' : '' }}>
                                    {{ $company->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('company_id') <p class="mt-1.5 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Template
                            Name <span class="text-red-500 ml-1">*</span></label>
                        <input type="text" name="name" value="{{ old('name') }}" required
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm"
                            placeholder="e.g. Welcome Email">
                        @error('name') <p class="mt-1.5 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                    </div>
                    <div class="md:col-span-2">
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Email
                            Subject <span class="text-red-500 ml-1">*</span></label>
                        <input type="text" name="subject" value="{{ old('subject') }}" required
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm"
                            placeholder="Enter email subject line">
                        @error('subject') <p class="mt-1.5 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                    </div>
                    <div class="md:col-span-2">
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Internal
                            Description <span class="text-slate-400 text-[10px] normal-case">(Optional)</span></label>
                        <textarea name="description" rows="2"
                            class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:outline-none focus:ring-4 focus:ring-blue-500/10 focus:border-blue-500 transition-all text-sm resize-none"
                            placeholder="Briefly describe the purpose of this template...">{{ old('description') }}</textarea>
                        @error('description') <p class="mt-1.5 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                    </div>
                </div>
            </div>

            <!-- Content Section -->
            <div class="pt-6 border-t border-slate-100">
                <div class="flex items-center gap-2 mb-6">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Email Content</h2>
                </div>

                <div>
                    <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Template Content
                        <span class="text-red-500 ml-1">*</span></label>
                    <div id="content-editor" style="height: 400px; background: white;"></div>
                    <textarea name="content" id="content-hidden" style="display: none;"></textarea>
                    <div class="mt-2 flex items-start gap-2 text-[10px] text-slate-400 font-medium">
                        <svg class="w-3.5 h-3.5 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span>Use placeholders like <code
                                class="px-1.5 py-0.5 bg-slate-100 rounded text-blue-600 font-bold">@{{employee_name}}</code>,
                            <code
                                class="px-1.5 py-0.5 bg-slate-100 rounded text-blue-600 font-bold">@{{company_name}}</code>
                            in your content. HTML is supported.</span>
                    </div>
                    @error('content') <p class="mt-1.5 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                </div>
            </div>

            <!-- Attachment & Settings Section -->
            <div class="pt-6 border-t border-slate-100">
                <div class="flex items-center gap-2 mb-6">
                    <span class="w-1.5 h-6 bg-blue-600 rounded-full"></span>
                    <h2 class="text-xs font-black text-slate-900 uppercase tracking-widest">Attachment & Settings</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="text-[11px] font-bold text-slate-500 uppercase tracking-wider mb-2 block">Attach
                            Document <span class="text-slate-400 text-[10px] normal-case">(Optional)</span></label>
                        <input type="file" name="attachment"
                            class="w-full text-sm text-slate-600 file:mr-4 file:py-2.5 file:px-4 file:rounded-xl file:border-0 file:text-xs file:font-bold file:bg-blue-600 file:text-white hover:file:bg-blue-700 file:transition-all border border-slate-200 rounded-xl p-2 bg-slate-50 cursor-pointer">
                        <p class="mt-2 text-[10px] text-slate-400 font-medium flex items-center gap-1.5">
                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Max size: 10MB (PDF, DOCS, Images)
                        </p>
                        @error('attachment') <p class="mt-1.5 text-xs text-red-500 font-bold">{{ $message }}</p> @enderror
                    </div>
                    <div class="flex items-center gap-3 pt-6">
                        <input type="hidden" name="is_active" value="0">
                        <input type="checkbox" name="is_active" value="1" id="is_active" {{ old('is_active', true) ? 'checked' : '' }}
                            class="w-5 h-5 text-blue-600 border-slate-300 rounded-lg focus:ring-4 focus:ring-blue-500/20 transition-all cursor-pointer">
                        <label for="is_active" class="text-sm font-bold text-slate-700 cursor-pointer select-none">Enable
                            this template immediately</label>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="pt-8 border-t border-slate-100 flex items-center gap-4">
                <button type="submit"
                    class="px-10 py-3 bg-blue-600 text-white font-bold rounded-xl hover:bg-blue-700 transition-all shadow-lg shadow-blue-500/20 flex items-center gap-2 text-sm">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4">
                        </path>
                    </svg>
                    Create Template
                </button>
                <a href="{{ route('admin.email-templates.index') }}"
                    class="px-8 py-3 bg-slate-100 text-slate-600 font-bold rounded-xl hover:bg-slate-200 transition-all text-sm">
                    Cancel
                </a>
            </div>
        </form>
    </div>
    <!-- Quill Editor CSS -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

    <!-- Quill Editor JS -->
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const companySelect = document.querySelector('select[name="company_id"]');

            // Pass PHP signatures to JS
            const signatures = @json($emailSignatures ?? []);

            // Initialize Quill Editor
            var quill = new Quill('#content-editor', {
                theme: 'snow',
                modules: {
                    toolbar: [
                        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                        ['bold', 'italic', 'underline', 'strike'],
                        [{ 'color': [] }, { 'background': [] }],
                        [{ 'align': [] }],
                        [{ 'list': 'ordered' }, { 'list': 'bullet' }],
                        ['blockquote', 'code-block'],
                        ['link', 'image'],
                        ['clean']
                    ]
                },
                placeholder: 'Start typing your email content here...'
            });

            // Get the hidden textarea
            const form = document.querySelector('form');
            const hiddenInput = document.getElementById('content-hidden');

            // Update hidden textarea whenever content changes
            quill.on('text-change', function () {
                hiddenInput.value = quill.root.innerHTML;
            });

            // Also update on form submission
            form.addEventListener('submit', function (e) {
                const content = quill.root.innerHTML;
                const textContent = quill.getText().trim();

                // Update hidden field
                hiddenInput.value = content;

                // Check if editor has actual content (not just empty tags)
                if (!textContent || textContent.length === 0) {
                    e.preventDefault();
                    alert('Please enter email content before submitting.');
                    return false;
                }
            });

            // Handle company signature
            companySelect.addEventListener('change', function () {
                const companyId = this.value;
                if (!companyId) return;

                const companySignatures = signatures[companyId];
                if (companySignatures && companySignatures.length > 0) {
                    const defaultSig = companySignatures.find(s => s.is_default) || companySignatures[0];

                    if (defaultSig && defaultSig.content) {
                        const currentContent = quill.root.innerHTML;
                        if (!currentContent.includes(defaultSig.content)) {
                            const spacing = currentContent.trim() ? "<br><br>" : "";
                            quill.root.innerHTML = currentContent + spacing + defaultSig.content;
                        }
                    }
                }
            });
        });
    </script>
    </div>
@endsection