@extends('layouts.admin')

@section('title', 'Admin - Create Email Signature')

@section('content')
    <div class="p-6">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800">Add Email Signature</h1>
            <p class="text-gray-500">Create a new email signature for a company.</p>
        </div>

        <div class="max-w-4xl bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <form action="{{ route('admin.email-signatures.store') }}" method="POST" class="p-6 space-y-6">
                @csrf

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Company <span
                                class="text-red-500">*</span></label>
                        <select name="company_id" required
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none">
                            <option value="">Select Company</option>
                            @foreach($companies as $company)
                                <option value="{{ $company->id }}" {{ old('company_id') == $company->id ? 'selected' : '' }}>
                                    {{ $company->name }}</option>
                            @endforeach
                        </select>
                        @error('company_id') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Signature Name <span
                                class="text-red-500">*</span></label>
                        <input type="text" name="name" value="{{ old('name') }}" required
                            class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none"
                            placeholder="e.g. Standard Support Signature">
                        @error('name') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-bold text-gray-500 uppercase mb-2">Signature Content <span
                            class="text-red-500">*</span></label>
                    <textarea name="content" required id="signature-editor"
                        class="w-full px-4 py-2 border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none h-48">{{ old('content') }}</textarea>
                    <p class="mt-2 text-[10px] text-gray-400 font-medium">Tip: Use HTML for better formatting (e.g.,
                        &lt;br&gt;, &lt;strong&gt;, &lt;a&gt;).</p>
                    @error('content') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                </div>

                <div class="flex items-center gap-2">
                    <input type="hidden" name="is_default" value="0">
                    <input type="checkbox" name="is_default" value="1" id="is_default" {{ old('is_default') ? 'checked' : '' }} class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                    <label for="is_default" class="text-sm font-medium text-gray-700">Set as default signature for this
                        company</label>
                </div>

                <div class="pt-6 border-t border-gray-100 flex gap-3">
                    <button type="submit"
                        class="px-8 py-3 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-all shadow-md shadow-blue-500/20">
                        Save Signature
                    </button>
                    <a href="{{ route('admin.email-signatures.index') }}"
                        class="px-8 py-3 bg-gray-100 text-gray-600 font-bold rounded-lg hover:bg-gray-200 transition-all">
                        Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection