@extends('layouts.user')

@section('title', 'Create Email Campaign')

@section('content')
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="mb-8 flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-gray-900 tracking-tight">Create Campaign</h1>
                <p class="text-gray-500 mt-1">Design and schedule a new email broadcast.</p>
            </div>
            <a href="{{ route('email-campaigns.index') }}"
                class="px-4 py-2 text-sm font-semibold text-gray-600 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition-all shadow-sm">
                Cancel
            </a>
        </div>

        <div class="bg-white rounded-2xl shadow-xl shadow-gray-200/50 border border-gray-100 overflow-hidden">
            <form action="{{ route('email-campaigns.store') }}" method="POST" enctype="multipart/form-data"
                x-data="{ recipientType: 'clients', schedule: false }">
                @csrf

                <div class="p-8 space-y-8">
                    <!-- section 1: Basic Info -->
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <span
                                class="w-6 h-6 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center text-xs">1</span>
                            Campaign Details
                        </h3>
                        <div class="space-y-4 ml-8">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">
                                    Campaign Name
                                    <span x-show="recipientType === 'particular'"
                                        class="text-xs font-normal text-gray-400">(Optional)</span>
                                </label>
                                <input type="text" name="name"
                                    class="w-full px-4 py-2.5 bg-gray-50 border border-gray-200 rounded-lg focus:bg-white focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all outline-none"
                                    :required="recipientType !== 'particular'"
                                    placeholder="e.g. Monthly Newsletter - January">
                            </div>
                        </div>
                    </div>

                    <div class="w-full h-px bg-gray-100"></div>

                    <!-- Section 2: Audience -->
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <span
                                class="w-6 h-6 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center text-xs">2</span>
                            Target Audience
                        </h3>
                        <div class="ml-8 space-y-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Who should receive this
                                email?</label>
                            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                                <!-- Option: Clients -->
                                <label
                                    class="relative flex flex-col p-4 bg-white border-2 rounded-xl cursor-pointer hover:bg-gray-50 transition-all"
                                    :class="recipientType === 'clients' ? 'border-blue-500 bg-blue-50/10 ring-1 ring-blue-500' : 'border-gray-200'">
                                    <input type="radio" name="recipient_type" value="clients" x-model="recipientType"
                                        class="absolute opacity-0">
                                    <span class="font-bold text-gray-900 mb-1">Clients / Leads</span>
                                    <span class="text-xs text-gray-500">Send to all saved leads.</span>
                                    <div x-show="recipientType === 'clients'" class="absolute top-3 right-3 text-blue-500">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                </label>

                                <!-- Option: Employees -->
                                <label
                                    class="relative flex flex-col p-4 bg-white border-2 rounded-xl cursor-pointer hover:bg-gray-50 transition-all"
                                    :class="recipientType === 'employees' ? 'border-blue-500 bg-blue-50/10 ring-1 ring-blue-500' : 'border-gray-200'">
                                    <input type="radio" name="recipient_type" value="employees" x-model="recipientType"
                                        class="absolute opacity-0">
                                    <span class="font-bold text-gray-900 mb-1">Employees</span>
                                    <span class="text-xs text-gray-500">All active staff members.</span>
                                    <div x-show="recipientType === 'employees'"
                                        class="absolute top-3 right-3 text-blue-500">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                </label>

                                <!-- Option: Particular -->
                                <label
                                    class="relative flex flex-col p-4 bg-white border-2 rounded-xl cursor-pointer hover:bg-gray-50 transition-all"
                                    :class="recipientType === 'particular' ? 'border-blue-500 bg-blue-50/10 ring-1 ring-blue-500' : 'border-gray-200'">
                                    <input type="radio" name="recipient_type" value="particular" x-model="recipientType"
                                        class="absolute opacity-0">
                                    <span class="font-bold text-gray-900 mb-1">Single Recipient</span>
                                    <span class="text-xs text-gray-500">Send to a specific email.</span>
                                    <div x-show="recipientType === 'particular'"
                                        class="absolute top-3 right-3 text-blue-500">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                </label>

                                <!-- Option: Custom -->
                                <label
                                    class="relative flex flex-col p-4 bg-white border-2 rounded-xl cursor-pointer hover:bg-gray-50 transition-all"
                                    :class="recipientType === 'custom' ? 'border-blue-500 bg-blue-50/10 ring-1 ring-blue-500' : 'border-gray-200'">
                                    <input type="radio" name="recipient_type" value="custom" x-model="recipientType"
                                        class="absolute opacity-0">
                                    <span class="font-bold text-gray-900 mb-1">Custom Upload</span>
                                    <span class="text-xs text-gray-500">Upload CSV/Excel file.</span>
                                    <div x-show="recipientType === 'custom'" class="absolute top-3 right-3 text-blue-500">
                                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                </label>
                            </div>

                            <!-- Single Recipient Input -->
                            <div x-show="recipientType === 'particular'" x-transition
                                class="mt-4 p-5 bg-gray-50 border border-gray-200 border-dashed rounded-xl">
                                <label class="block text-sm font-bold text-gray-700 mb-2">Recipient Email Address</label>
                                <input type="email" name="specific_email"
                                    class="w-full px-4 py-2.5 bg-white border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 transition-all outline-none"
                                    placeholder="Enter individual email address...">
                            </div>

                            <!-- Detailed Upload Section -->
                            <div x-show="recipientType === 'custom'" x-transition
                                class="mt-4 p-5 bg-gray-50 border border-gray-200 border-dashed rounded-xl">
                                <div class="flex items-center justify-between mb-2">
                                    <label class="text-sm font-bold text-gray-700">Upload Recipient List</label>
                                    <span class="text-xs bg-white px-2 py-1 rounded border text-gray-500">.csv, .xlsx</span>
                                </div>
                                <input type="file" name="custom_file" accept=".csv, .xlsx, .xls"
                                    class="block w-full text-sm text-slate-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-semibold file:bg-blue-600 file:text-white hover:file:bg-blue-700 transition cursor-pointer">
                                <p class="text-xs text-gray-500 mt-2 flex items-center gap-1">
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    Ensure the file has a column containing email addresses.
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="w-full h-px bg-gray-100"></div>

                    <!-- Section 3: Content -->
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <span
                                class="w-6 h-6 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center text-xs">3</span>
                            Message Content
                        </h3>
                        <div class="ml-8">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Select Template</label>
                            <div class="relative">
                                <select name="email_template_id"
                                    class="w-full px-4 py-3 bg-gray-50 border border-gray-200 rounded-xl focus:bg-white focus:ring-2 focus:ring-blue-500/20 focus:border-blue-500 outline-none appearance-none"
                                    required>
                                    <option value="">Choose an email template...</option>
                                    @foreach($templates as $templ)
                                        <option value="{{ $templ->id }}">{{ $templ->name }} &mdash; Subject:
                                            "{{ $templ->subject }}"</option>
                                    @endforeach
                                </select>
                                <div
                                    class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-gray-500">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7"></path>
                                    </svg>
                                </div>
                            </div>
                            <p class="text-xs text-gray-500 mt-2 text-right">
                                <a href="{{ route('email-templates.create') }}" class="text-blue-600 hover:underline">Create
                                    new template</a>
                            </p>
                        </div>
                    </div>

                    <div class="w-full h-px bg-gray-100"></div>

                    <!-- Section 4: Schedule -->
                    <div class="bg-blue-50/50 -mx-8 -mb-8 p-8 border-t border-blue-100">
                        <div class="flex items-start gap-4">
                            <div class="flex-1">
                                <div class="flex items-center gap-3 mb-2">
                                    <div
                                        class="relative inline-block w-12 mr-2 align-middle select-none transition duration-200 ease-in">
                                        <input type="checkbox" name="toggle" id="toggle" x-model="schedule"
                                            class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 border-gray-300 appearance-none cursor-pointer peer checked:right-0 checked:border-blue-600" />
                                        <label for="toggle"
                                            class="toggle-label block overflow-hidden h-6 rounded-full bg-gray-300 cursor-pointer peer-checked:bg-blue-600"></label>
                                    </div>
                                    <label for="toggle" class="font-bold text-gray-900 cursor-pointer">Schedule for
                                        Later</label>
                                </div>
                                <p class="text-sm text-gray-500 ml-16" x-show="!schedule">Campaign will be saved as draft.
                                    You can send it immediately after creating.</p>

                                <div x-show="schedule" x-transition
                                    class="ml-16 mt-4 p-4 bg-white rounded-xl border border-blue-200 shadow-sm">
                                    <label class="block text-sm font-bold text-gray-800 mb-2">Select Date & Time</label>
                                    <input type="datetime-local" name="scheduled_at"
                                        class="w-full border-gray-200 rounded-lg focus:ring-blue-500 focus:border-blue-500">
                                    <p class="text-xs text-blue-600 mt-2 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        System will automatically process this campaign at the specified time.
                                    </p>
                                </div>
                            </div>

                            <div class="w-48">
                                <button type="submit"
                                    class="w-full py-4 bg-gradient-to-r from-blue-600 to-blue-700 text-white font-bold rounded-xl hover:from-blue-700 hover:to-blue-800 transition-all shadow-xl shadow-blue-500/20 transform hover:-translate-y-0.5"
                                    x-text="schedule ? 'Schedule Campaign' : 'Create Draft'">
                                    Create Campaign
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <style>
                    .toggle-checkbox:checked {
                        right: 0;
                        border-color: #2563EB;
                    }

                    .toggle-checkbox:checked+.toggle-label {
                        background-color: #2563EB;
                    }

                    .toggle-checkbox {
                        right: auto;
                        left: 0;
                        transition: all 0.3s;
                    }

                    .toggle-label {
                        width: 3rem;
                    }
                </style>
            </form>
        </div>
    </div>
@endsection