@extends('layouts.admin')

@section('title', 'Admin Activity Logs')

@section('content')
    <div class="max-w-7xl mx-auto space-y-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-black text-slate-900 tracking-tight uppercase">Admin Activity Logs</h1>
                <p class="text-slate-500 font-bold mt-1 uppercase tracking-widest text-xs">Track user actions and changes
                </p>
            </div>
            <form action="{{ route('admin.activity-logs.clear') }}" method="POST"
                onsubmit="return confirm('Are you sure you want to clear ALL logs? This cannot be undone.');">
                @csrf
                @method('DELETE')
                <button type="submit"
                    class="bg-red-50 text-red-600 hover:bg-red-100 px-5 py-2.5 rounded-xl font-bold text-xs uppercase tracking-wider transition-colors">
                    Clear All Logs
                </button>
            </form>
        </div>

        @if(session('success'))
            <div class="p-4 bg-green-50 border-l-4 border-green-500 text-green-700 font-bold rounded-r-xl">
                {{ session('success') }}
            </div>
        @endif

        <div class="bg-white rounded-3xl shadow-xl shadow-slate-200 border border-slate-100 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-slate-900">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">Time</th>
                            <th class="px-6 py-4 text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">User</th>
                            <th class="px-6 py-4 text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">Action
                            </th>
                            <th class="px-6 py-4 text-[10px] font-black text-slate-400 uppercase tracking-[0.2em]">
                                Description</th>
                            <th
                                class="px-6 py-4 text-[10px] font-black text-slate-400 uppercase tracking-[0.2em] text-right">
                                Details</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-100">
                        @forelse($logs as $log)
                                            <tr class="hover:bg-slate-50 transition-colors">
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="text-xs font-bold text-slate-900">{{ $log->created_at->format('M d, Y') }}</div>
                                                    <div class="text-[10px] font-bold text-slate-400 uppercase tracking-wider mt-0.5">
                                                        {{ $log->created_at->format('H:i:s') }}</div>
                                                </td>
                                                <td class="px-6 py-4">
                                                    <div class="flex items-center gap-3">
                                                        <div
                                                            class="w-8 h-8 bg-blue-50 text-blue-600 rounded-lg flex items-center justify-center font-black text-xs">
                                                            {{ substr($log->user->name ?? '?', 0, 1) }}
                                                        </div>
                                                        <div>
                                                            <div class="text-xs font-bold text-slate-900">
                                                                {{ $log->user->name ?? 'System/Unknown' }}</div>
                                                            <div class="text-[10px] font-bold text-slate-400">{{ $log->ip_address }}</div>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="px-6 py-4">
                                                    @php
                                                        $color = match ($log->action) {
                                                            'created' => 'text-green-600 bg-green-50',
                                                            'updated' => 'text-blue-600 bg-blue-50',
                                                            'deleted' => 'text-red-600 bg-red-50',
                                                            default => 'text-slate-600 bg-slate-50'
                                                        };
                                                    @endphp
                             <span
                                                        class="inline-block px-2.5 py-1 rounded-md text-[10px] font-black uppercase tracking-wider {{ $color }}">
                                                        {{ $log->action }}
                                                    </span>
                                                </td>
                                                <td class="px-6 py-4">
                                                    <div class="text-xs font-bold text-slate-700">{{ $log->description }}</div>
                                                    <div class="text-[10px] text-slate-400 mt-1 font-mono">{{ $log->subject_type }}
                                                        #{{ $log->subject_id }}</div>
                                                </td>
                                                <td class="px-6 py-4 text-right">
                                                    @if($log->properties && count($log->properties) > 0)
                                                        <div x-data="{ open: false }">
                                                            <button @click="open = !open"
                                                                class="text-[10px] font-bold text-blue-600 uppercase tracking-wider hover:underline">
                                                                View Changes
                                                            </button>
                                                            <div x-show="open" @click.outside="open = false"
                                                                class="absolute z-10 mt-2 right-10 w-80 bg-white rounded-xl shadow-2xl border border-slate-100 p-4 text-left"
                                                                style="display: none;">
                                                                <h4 class="text-[10px] font-black text-slate-400 uppercase tracking-wider mb-2">
                                                                    Changed Attributes</h4>
                                                                <div
                                                                    class="space-y-1 text-xs font-mono bg-slate-50 p-3 rounded-lg text-slate-600 break-all max-h-60 overflow-y-auto">
                                                                    @foreach($log->properties['attributes'] ?? [] as $key => $val)
                                                                        <div class="flex gap-2">
                                                                            <span class="font-bold text-slate-800">{{ $key }}:</span>
                                                                            <span
                                                                                class="text-slate-500">{{ is_array($val) ? json_encode($val) : $val }}</span>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <span class="text-[10px] font-bold text-slate-300 uppercase">No Details</span>
                                                    @endif
                                                </td>
                                            </tr>
                        @empty
                            <tr>
                                <td colspan="5"
                                    class="px-6 py-12 text-center text-slate-400 font-bold uppercase tracking-wider text-xs">
                                    No activity logs found.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($logs->hasPages())
                <div class="p-6 border-t border-slate-100">
                    {{ $logs->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection