@extends('layouts.user')

@section('title', 'Add-on Schedules History')

@section('content')
    <div class="p-6">
        <div class="p-6">
            <div class="mb-6">
                <h1 class="text-2xl font-bold text-gray-800">Add-on Schedules</h1>
                <p class="text-gray-500">Manage missed items and review manual completions.</p>
            </div>



            <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Duty #</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Site</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Employee</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider">Manual Entry
                                Times</th>
                            <th class="px-6 py-4 text-[11px] font-bold text-gray-400 uppercase tracking-wider text-right">
                                Evidence</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($schedules as $schedule)
                            @foreach($schedule->employees as $emp)
                                @if($emp->pivot->is_addon)
                                    <tr class="hover:bg-gray-50 transition-colors">
                                        <td class="px-6 py-4">
                                            <span class="text-sm font-bold text-gray-900">{{ $schedule->duty_number }}</span>
                                            <div class="text-xs text-slate-400">{{ $schedule->from_datetime->format('M d, Y') }}</div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <span class="text-sm font-bold text-gray-800">{{ $schedule->virtual_site->name }}</span>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="flex items-center gap-2">
                                                <span class="text-sm font-bold text-slate-700">{{ $emp->first_name }}
                                                    {{ $emp->last_name }}</span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4">
                                            <div class="text-xs text-gray-600">
                                                <span class="font-bold text-blue-600">In:</span>
                                                {{ \Carbon\Carbon::parse($emp->pivot->actual_start_at)->format('h:i A') }}
                                            </div>
                                            <div class="text-xs text-gray-600">
                                                <span class="font-bold text-amber-600">Out:</span>
                                                {{ \Carbon\Carbon::parse($emp->pivot->actual_end_at)->format('h:i A') }}
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 text-right">
                                            <div class="flex justify-end gap-2">
                                                @php
                                                    $hasImages = $emp->pivot->start_evidence_path || $emp->pivot->end_evidence_path;
                                                    $isPatrol = $schedule instanceof \App\Models\PatrollerSchedule;
                                                @endphp

                                                @if($hasImages)
                                                    <a href="{{ route('addon-schedules.download-evidence', ['schedule' => $schedule->id, 'employee_id' => $emp->id, 'type' => $isPatrol ? 'patrol' : 'guard']) }}"
                                                        class="flex items-center gap-1 text-xs font-bold text-blue-600 hover:text-blue-800 bg-blue-50 px-3 py-1.5 rounded transition-colors border border-blue-100">
                                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path></svg>
                                                        Zip
                                                    </a>
                                                @endif

                                                @if(!$isPatrol)
                                                    <a href="{{ route('schedules.report.download', $schedule->id) }}"
                                                        class="flex items-center gap-1 text-xs font-bold text-red-600 hover:text-red-800 bg-red-50 px-3 py-1.5 rounded transition-colors border border-red-100">
                                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path></svg>
                                                        PDF
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endif
                            @endforeach
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center text-gray-400 italic">
                                    No history found.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                {{ $schedules->appends(request()->query())->links() }}
            </div>
        </div>
@endsection