@extends('layouts.user')

@section('title', 'Activity Logs')

@section('content')
    <div class="space-y-6">
        <!-- Header -->
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
            <div>
                <h1 class="text-2xl font-bold text-gray-800">Activity Logs</h1>
                <p class="text-sm text-gray-500 mt-1">View your recent activities and audit trail.</p>
            </div>

            <div class="flex flex-wrap items-center gap-3">
                <!-- Range Filters -->
                <div class="flex bg-white rounded-lg shadow-sm border border-gray-200 p-1">
                    <a href="{{ route('activity-logs.index', ['range' => 'today']) }}"
                        class="px-3 py-1.5 text-xs font-semibold rounded-md transition-colors {{ request('range', 'today') == 'today' ? 'bg-blue-50 text-blue-600' : 'text-gray-600 hover:bg-gray-50' }}">
                        Today
                    </a>
                    <a href="{{ route('activity-logs.index', ['range' => 'weekly']) }}"
                        class="px-3 py-1.5 text-xs font-semibold rounded-md transition-colors {{ request('range') == 'weekly' ? 'bg-blue-50 text-blue-600' : 'text-gray-600 hover:bg-gray-50' }}">
                        Weekly
                    </a>
                    <a href="{{ route('activity-logs.index', ['range' => 'monthly']) }}"
                        class="px-3 py-1.5 text-xs font-semibold rounded-md transition-colors {{ request('range') == 'monthly' ? 'bg-blue-50 text-blue-600' : 'text-gray-600 hover:bg-gray-50' }}">
                        Monthly
                    </a>
                </div>

                <!-- Export Actions -->
                <div class="flex items-center gap-2">
                    <a href="{{ route('activity-logs.export.pdf', ['range' => request('range', 'today')]) }}"
                        target="_blank"
                        class="h-[34px] px-3 bg-white border border-gray-300 text-gray-700 text-xs font-bold rounded-lg hover:bg-gray-50 transition-colors flex items-center gap-2 shadow-sm">
                        <svg class="w-4 h-4 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z">
                            </path>
                        </svg>
                        Export PDF
                    </a>
                    <a href="{{ route('activity-logs.export.excel', ['range' => request('range', 'today')]) }}"
                        target="_blank"
                        class="h-[34px] px-3 bg-white border border-gray-300 text-gray-700 text-xs font-bold rounded-lg hover:bg-gray-50 transition-colors flex items-center gap-2 shadow-sm">
                        <svg class="w-4 h-4 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                        Download Report
                    </a>
                </div>
            </div>
        </div>

        <!-- Logs Table -->
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/50 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Date & Time
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Action</th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">Description
                            </th>
                            <th class="px-6 py-4 text-[10px] font-bold text-gray-400 uppercase tracking-wider">IP Address
                            </th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        @forelse($logs as $log)
                            <tr class="hover:bg-gray-50/50 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500 font-medium">
                                    {{ $log->created_at->format('M d, Y h:i A') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span
                                        class="px-2 py-1 rounded-full text-[10px] font-bold uppercase tracking-wide bg-blue-50 text-blue-600 border border-blue-100">
                                        {{ $log->action }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-600">
                                    {{ $log->description ?: '-' }}
                                    @if($log->subject_type && $log->subject_id)
                                        <span class="text-xs text-gray-400 block mt-0.5">Ref:
                                            {{ class_basename($log->subject_type) }} #{{ $log->subject_id }}</span>
                                    @endif
                                    @if($log->properties)
                                        <pre
                                            class="text-[10px] text-gray-500 mt-1 bg-gray-50 p-1 rounded overflow-x-auto">{{ json_encode($log->properties, JSON_PRETTY_PRINT) }}</pre>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500 font-mono">
                                    {{ $log->ip_address ?: '-' }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-6 py-12 text-center text-gray-500 text-sm">
                                    No activity logs found for this period.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($logs->hasPages())
                <div class="px-6 py-4 border-t border-gray-100 bg-gray-50">
                    {{ $logs->links() }}
                </div>
            @endif
        </div>
    </div>
@endsection