
import os
import re

path = 'e:/new_guard/resources/views/employees/edit.blade.php'
with open(path, 'r', encoding='utf-8') as f:
    content = f.read()

# Fix Job Role
content = re.sub(r"selected\s*=\s*'\{\{\s*\$employee->jobRole\s*\?\s*\$employee->jobRole->name\s*:\s*'Select Job Role'\s*\}\}';", 
                 r"selected = {{ json_encode($employee->jobRole ? $employee->jobRole->name : 'Select Job Role') }};", content)

# Fix Province
content = re.sub(r"@php\s*\$provinceName\s*=\s*\$provinces->where\('id',\s*\$employee->licence_issuing_province_id\)->first\(\)->name\s*\?\?\s*'Select Province';\s*@endphp\s*selected\s*=\s*'\{\{\s*\$provinceName\s*\}\}';", 
                 r"selected = {{ json_encode($provinces->where('id', $employee->licence_issuing_province_id)->first()->name ?? 'Select Province') }};", content, flags=re.DOTALL)

# Remove spacers
content = content.replace('<div class="hidden md:block"></div>', '')

with open(path, 'w', encoding='utf-8') as f:
    f.write(content)
