$file = "resources/views/employees/edit.blade.php"
$content = Get-Content $file -Raw

# Pattern 1: Fix dropdowns with x-data="{ open: false, search: '', selected: '', value: '' }"
$pattern1 = '(<div[^>]*x-data="\{ open: false, search: '''', selected: '''', value: ''''[^'']*'''' \}")(\s*>)(\s*<label[^>]*>.*?</label>)(\s*<input[^>]*>)(\s*<button[^>]*@click="open = !open")\s+@click\.outside="open = false"'
$replacement1 = '$1 @click.outside="open = false"$2$3$4$5'

$content = $content -replace $pattern1, $replacement1

# Pattern 2: Fix Wage Type dropdown with x-data="{ open: false, search: ''}"
$pattern2 = '(<div[^>]*x-data="\{ open: false, search: '''' *\}")(\s*>)([^<]*<label[^>]*>.*?</template>)(\s*<button[^>]*@click="open = !open")\s+@click\.outside="open = false"'
$replacement2 = '$1 @click.outside="open = false"$2$3$4'

$content = $content -replace $pattern2, $replacement2

Set-Content $file -Value $content

Write-Host "Fixed dropdowns in edit.blade.php"
