<?php

$files = [
    'resources/views/employees/create.blade.php',
    'resources/views/employees/edit.blade.php'
];

foreach ($files as $file) {
    if (!file_exists($file)) {
        echo "File not found: $file\n";
        continue;
    }

    $content = file_get_contents($file);

    // Pattern to find searchable dropdowns and fix them
    // Find: <div ... x-data="{ open: false, search: '', selected: '', value: '' }">
    // And move @click.outside from button to this div

    $pattern = '/(<div[^>]*x-data="\{ open: false, search: \'\', selected: \'\', value: \'[^\']*\' \}")(>.*?<button[^>]*@click="open = !open")(\s+@click\.outside="open = false")/s';

    $replacement = '$1 @click.outside="open = false"$2';

    $newContent = preg_replace($pattern, $replacement, $content);

    if ($newContent !== $content) {
        file_put_contents($file, $newContent);
        echo "✓ Fixed searchable dropdowns in: $file\n";
    } else {
        echo "No changes needed in: $file\n";
    }
}

echo "\nDone!\n";
