<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Schedule;
use Carbon\Carbon;

// Force the timezone context to check what's happening
echo "App Config Timezone: " . config('app.timezone') . "\n";
echo "Current Carbon Now: " . Carbon::now()->format('Y-m-d H:i:s P') . "\n";

$schedule = Schedule::where('duty_number', 'DTY0392')->orWhere('duty_number', '#DTY0392')->first();

if ($schedule) {
    echo "--- Raw Database Values ---\n";
    // We get attributes directly to see what's in the DB without casting
    $attrs = $schedule->getAttributes();
    echo "DB From: " . $attrs['from_datetime'] . "\n";
    echo "DB To:   " . $attrs['to_datetime'] . "\n";

    echo "--- Casted Model Values ---\n";
    echo "Model From: " . $schedule->from_datetime->format('Y-m-d H:i:s P') . "\n";
    echo "Model To:   " . $schedule->to_datetime->format('Y-m-d H:i:s P') . "\n";

    echo "--- JSON Serialization (What API sends) ---\n";
    echo json_encode(['from' => $schedule->from_datetime, 'to' => $schedule->to_datetime], JSON_PRETTY_PRINT) . "\n";
} else {
    echo "Schedule DTY0392 not found.\n";
}
