<?php
$s = \App\Models\Schedule::where('duty_number', 'DTY-0215')->orWhere('duty_number', '215')->with('employees')->first();
$e = $s->employees->where('id', 83)->first(); // Gagandeep

echo "--- DEBUG START ---\n";
$start = \Carbon\Carbon::parse($e->pivot->actual_start_at);
$end = \Carbon\Carbon::parse($e->pivot->actual_end_at);
$hours = $end->diffInMinutes($start) / 60;

echo "Start: " . $start . "\n";
echo "End: " . $end . "\n";
echo "Hours: " . $hours . "\n";

$rate = $e->pivot->wage_rate;
echo "Wage Rate (Pivot): " . $rate . "\n";

$wageTypesRaw = $e->pivot->wage_types;
echo "Wage Types (Raw): " . $wageTypesRaw . "\n";

$wageTypes = json_decode($wageTypesRaw, true);
echo "Wage Types (Decoded Count): " . (is_array($wageTypes) ? count($wageTypes) : 'Not Array') . "\n";

$calculatedPay = 0;

if ($rate <= 0) {
    if (is_array($wageTypes) && count($wageTypes) > 0) {
        $remainingActualHours = $hours; // 9
        $loopCount = 0;
        foreach ($wageTypes as $wt) {
            $loopCount++;
            if ($remainingActualHours <= 0)
                break;

            $allocated = $wt['allocated_hours'] ?? 0;
            $componentRate = $wt['rate'] ?? 0;

            echo "Tier $loopCount: Allocated=$allocated, Rate=$componentRate, RemainingHours=$remainingActualHours\n";

            $hoursForThisComponent = min($remainingActualHours, $allocated);

            $payForTier = $hoursForThisComponent * $componentRate;
            $calculatedPay += $payForTier;

            echo "  -> Used: $hoursForThisComponent, Pay Added: $payForTier, AccPay: $calculatedPay\n";

            $remainingActualHours -= $hoursForThisComponent;
        }

        // Overflow
        if ($remainingActualHours > 0) {
            $lastComponent = end($wageTypes);
            $lastRate = $lastComponent['rate'] ?? 0;
            $overflowPay = $remainingActualHours * $lastRate;
            $calculatedPay += $overflowPay;
            echo "Overflow: $remainingActualHours hours @ $lastRate = $overflowPay. Total: $calculatedPay\n";
        }
    } else {
        echo "Wage types array empty or invalid.\n";
    }
} else {
    $calculatedPay = $hours * $rate;
    echo "Using Flat Rate: $hours * $rate = $calculatedPay\n";
}

echo "FINAL CALCULATED PAY: " . $calculatedPay . "\n";
