<?php

use App\Models\Schedule;
use Illuminate\Support\Facades\DB;

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

$dutyNumber = 'DTY0239';

echo "Debugging Payout for $dutyNumber\n";
echo "--------------------------------------------------\n";

$schedule = DB::table('schedules')
    ->where('duty_number', $dutyNumber)
    ->first();

if (!$schedule) {
    echo "Schedule not found.\n";
    exit;
}

echo "Schedule ID: {$schedule->id}\n";
echo "Date: {$schedule->schedule_date}\n";

$employeeSchedules = DB::table('employee_schedule')
    ->where('schedule_id', $schedule->id)
    ->get();

foreach ($employeeSchedules as $es) {
    echo "\nEmployee ID: {$es->employee_id}\n";
    echo "Wage Types (JSON): {$es->wage_types}\n";
    echo "Pivot Wage Rate: {$es->wage_rate}\n";

    // Decode wage types
    $wtIds = json_decode($es->wage_types, true);
    if (is_array($wtIds)) {
        echo "Decoded Wage Type IDs: " . implode(', ', $wtIds) . "\n";

        // Fetch rates from employee_wage_type
        $rates = DB::table('employee_wage_type')
            ->join('wage_types', 'employee_wage_type.wage_type_id', '=', 'wage_types.id')
            ->where('employee_id', $es->employee_id)
            ->whereIn('wage_type_id', $wtIds)
            ->select('wage_types.name', 'employee_wage_type.rate', 'employee_wage_type.wage_type_id')
            ->get();

        echo "Defined Rates for this Employee:\n";
        foreach ($rates as $r) {
            echo " - ID {$r->wage_type_id} ({$r->name}): {$r->rate}\n";
        }

        echo "Sum of Defined Rates: " . $rates->sum('rate') . "\n";
    } else {
        echo "Wage Types is not an array or is invalid.\n";
    }
}
