<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$emp = App\Models\Employee::where('employee_id', 'FEMP00101')->first();

if ($emp) {
    echo 'Employee Found: ' . $emp->id . ' Name: ' . $emp->first_name . ' ' . $emp->last_name . PHP_EOL;
    echo 'Company ID: ' . $emp->company_id . PHP_EOL;

    // Check identifications relationship
    $licenses = $emp->identifications;
    echo 'License Count (Relationship): ' . $licenses->count() . PHP_EOL;
    foreach ($licenses as $l) {
        $expiry = $l->expiry_date ? $l->expiry_date->format('Y-m-d') : 'NULL';
        echo "License ID: {$l->id} | Type: {$l->type} | Expiry: {$expiry}" . PHP_EOL;
    }

    // Check raw identifications table
    $rawLicenses = \DB::table('employee_identifications')->where('employee_id', $emp->id)->get();
    echo 'Raw DB Count: ' . $rawLicenses->count() . PHP_EOL;
    foreach ($rawLicenses as $rl) {
        echo "Raw ID: {$rl->id} | Expiry: " . ($rl->expiry_date ?? 'NULL') . PHP_EOL;
    }

    // Check `license_expiry` column in `employees` table (Legacy/Main table)
    echo "Employee Table License Expiry: " . ($emp->license_expiry ? $emp->license_expiry : 'NULL') . PHP_EOL;

} else {
    echo 'Employee FEMP00101 Not Found' . PHP_EOL;
}
