<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

$employee = \App\Models\Employee::find(83);

if ($employee) {
    echo "Employee ID: {$employee->id}\n";
    echo "Name: {$employee->first_name} {$employee->last_name}\n";
    echo "Licence Province ID: " . ($employee->licence_issuing_province_id ?? 'NULL') . "\n";

    if ($employee->licence_issuing_province_id) {
        $province = \App\Models\State::find($employee->licence_issuing_province_id);
        echo "Province Found: " . ($province ? $province->name : 'NOT FOUND') . "\n";
    }

    echo "\nAll States in database:\n";
    $states = \App\Models\State::orderBy('name')->get();
    foreach ($states as $state) {
        echo "  ID: {$state->id} - Name: {$state->name}\n";
    }
} else {
    echo "Employee #83 not found\n";
}
