<?php
// debug_duty_dty0380.php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$dutyNumber = 'DTY0380';
$schedule = \App\Models\Schedule::where('duty_number', $dutyNumber)->first();

if (!$schedule) {
    echo "Schedule with duty number {$dutyNumber} not found.\n";
} else {
    echo "Schedule Found: ID {$schedule->id}\n";
    echo "Duty Number: {$schedule->duty_number}\n";
    echo "Status: {$schedule->status}\n";
    echo "Scheduled Start: {$schedule->from_datetime}\n";
    echo "Scheduled End: {$schedule->to_datetime}\n";

    echo "\nAssigned Employees:\n";
    foreach ($schedule->employees as $emp) {
        $pivot = $emp->pivot;
        echo "- Employee: {$emp->first_name} {$emp->last_name} (ID: {$emp->id})\n";
        echo "  Actual Start: " . ($pivot->actual_start_at ?? 'Not Started') . "\n";
        echo "  Actual End: " . ($pivot->actual_end_at ?? 'Not Ended') . "\n";
        echo "  Cancellation Status: " . ($pivot->cancellation_status ?? 'None') . "\n";
    }

    // Check if any other logs exist
    $scanCount = \App\Models\CheckpointScan::where('schedule_id', $schedule->id)->count();
    $incidentCount = \App\Models\Incident::where('schedule_id', $schedule->id)->count();

    echo "\nRelated Activity:\n";
    echo "Checkpoints Scanned: {$scanCount}\n";
    echo "Incidents Reported: {$incidentCount}\n";
}
