<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Schedule;

$duties = ['#DTY0381', '#DTY0385'];

foreach ($duties as $duty) {
    $schedule = Schedule::where('duty_number', $duty)->first();
    if (!$schedule) {
        $duty_clean = str_replace('#', '', $duty);
        $schedule = Schedule::where('duty_number', $duty_clean)->first();
    }

    if ($schedule) {
        echo "Schedule: {$schedule->duty_number}\n";
        echo "Status: {$schedule->status}\n";
        echo "From: {$schedule->from_datetime}\n";
        echo "To:   {$schedule->to_datetime}\n";

        echo "Employees:\n";
        foreach ($schedule->employees as $employee) {
            echo "  - {$employee->first_name} {$employee->last_name} (ID: {$employee->id})\n";
            echo "    Actual Start: " . ($employee->pivot->actual_start_at ?? 'NULL') . "\n";
            echo "    Actual End:   " . ($employee->pivot->actual_end_at ?? 'NULL') . "\n";
            echo "    Checkin Images: " . ($employee->pivot->checkin_images ? 'YES' : 'NO') . "\n";
        }
        echo "-------------------\n";
    } else {
        echo "Schedule {$duty} not found.\n";
    }
}
