<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\EmailTemplate;
use App\Models\Company;

class WelcomeEmailSeeder extends Seeder
{
    public function run()
    {
        $companies = Company::all();

        foreach ($companies as $company) {
            EmailTemplate::create([
                'company_id' => $company->id,
                'name' => 'Welcome Email (Modern)',
                'subject' => 'Welcome to the Team, @{{name}}!',
                'content' => '
<div style="background-color: #f3f4f6; padding: 40px 0; font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;">
    <div style="max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);">
        
        <!-- Header Section with Pattern/Image -->
        <div style="background: linear-gradient(135deg, #6366f1 0%, #a855f7 100%); padding: 40px 0; text-align: center;">
             <!-- Logo Placeholder -->
             <div style="margin-bottom: 20px;">
                <span style="background: rgba(255,255,255,0.2); color:white; padding: 8px 16px; border-radius: 20px; font-weight: bold; font-size: 14px; letter-spacing: 1px;">GUARD ROASTER</span>
             </div>
             <h1 style="color: #ffffff; font-size: 42px; margin: 0; font-weight: 800; letter-spacing: -1px; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">Welcome</h1>
             <p style="color: rgba(255,255,255,0.9); font-size: 18px; margin-top: 10px;">We\'re excited to have you!</p>
        </div>

        <!-- Body Content -->
        <div style="padding: 40px;">
            <p style="font-size: 16px; color: #374151; margin-bottom: 24px;">Hello <strong>@{{name}}</strong>,</p>
            
            <p style="font-size: 16px; color: #4b5563; line-height: 1.6; margin-bottom: 24px;">
                Welcome to the team! We are thrilled to have you join us at <strong>' . $company->name . '</strong>. 
                We believe you will be a fantastic addition to our workforce, and we can\'t wait to see the great things you\'ll achieve.
            </p>

            <p style="font-size: 16px; color: #4b5563; line-height: 1.6; margin-bottom: 32px;">
                To get started, please log in to your employee dashboard to review your schedule and complete your profile setup.
            </p>

            <!-- Call to Action Button -->
            <div style="text-align: center; margin-bottom: 32px;">
                <a href="' . route('employee.login') . '" style="background-color: #6366f1; color: #ffffff; padding: 14px 32px; border-radius: 8px; text-decoration: none; font-weight: bold; font-size: 16px; display: inline-block; transition: background-color 0.3s ease; box-shadow: 0 4px 6px rgba(99, 102, 241, 0.3);">
                    Access Dashboard
                </a>
            </div>

            <p style="font-size: 14px; color: #6b7280; text-align: center;">
                If you have any questions, feel free to reply to this email.
            </p>
        </div>

        <!-- Footer -->
        <div style="background-color: #f9fafb; padding: 24px; text-align: center; border-top: 1px solid #e5e7eb;">
            <p style="font-size: 12px; color: #9ca3af; margin: 0;">
                &copy; ' . date('Y') . ' ' . $company->name . '. All rights reserved.
            </p>
            <p style="font-size: 12px; color: #9ca3af; margin: 5px 0 0 0;">
                123 Security Ave, Suite 100, City, Country
            </p>
        </div>
    </div>
</div>
',
                'is_active' => true,
            ]);
        }
    }
}
