<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class TruncateScheduleDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Disable foreign key checks
        Schema::disableForeignKeyConstraints();

        // Truncate pivot/related tables first (to avoid foreign key issues)
        $this->truncateTable('checkpoint_scans');
        $this->truncateTable('schedule_tour_route');
        $this->truncateTable('checkpoint_tour_route');
        $this->truncateTable('employee_patroller_schedule');
        $this->truncateTable('patroller_job_sites');
        $this->truncateTable('schedule_wage_type');
        $this->truncateTable('employee_schedule');

        // Truncate main schedule tables
        $this->truncateTable('patroller_schedules');
        $this->truncateTable('schedules');

        // Truncate tour routes
        $this->truncateTable('tour_routes');
        $this->truncateTable('checkpoints');

        // Truncate routes and sites
        $this->truncateTable('routes');
        $this->truncateTable('sites');

        // Re-enable foreign key checks
        Schema::enableForeignKeyConstraints();

        $this->command->info('Successfully truncated all sites, routes, schedules, and related data!');
    }

    /**
     * Truncate a table if it exists
     */
    private function truncateTable(string $tableName): void
    {
        if (Schema::hasTable($tableName)) {
            DB::table($tableName)->truncate();
            $this->command->info("Truncated table: {$tableName}");
        } else {
            $this->command->warn("Table does not exist: {$tableName}");
        }
    }
}
