<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class TruncateEmployeeDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Disable foreign key checks
        Schema::disableForeignKeyConstraints();

        // Truncate employee-related pivot and child tables first
        $this->truncateTable('fcm_tokens');
        $this->truncateTable('guard_checkins');
        $this->truncateTable('guard_applications');
        $this->truncateTable('job_location_logs');
        $this->truncateTable('job_notes');
        $this->truncateTable('employee_request_replies');
        $this->truncateTable('employee_requests');
        $this->truncateTable('employee_uniforms');
        $this->truncateTable('employee_site_bans');
        $this->truncateTable('incidents');
        $this->truncateTable('checkpoint_scans');
        $this->truncateTable('employee_patroller_schedule');
        $this->truncateTable('employee_schedule');
        $this->truncateTable('employee_wage_type');
        $this->truncateTable('employee_identifications');
        $this->truncateTable('employee_experiences');
        $this->truncateTable('employee_skill');

        // Truncate schedule-related tables that reference employees
        $this->truncateTable('schedule_tour_route');
        $this->truncateTable('checkpoint_tour_route');
        $this->truncateTable('patroller_job_sites');
        $this->truncateTable('schedule_wage_type');

        // Truncate main schedule tables
        $this->truncateTable('patroller_schedules');
        $this->truncateTable('schedules');

        // Truncate tour routes and checkpoints
        $this->truncateTable('tour_routes');
        $this->truncateTable('checkpoints');

        // Truncate routes and sites
        $this->truncateTable('routes');
        $this->truncateTable('sites');

        // Finally, truncate the main employees table
        $this->truncateTable('employees');

        // Re-enable foreign key checks
        Schema::enableForeignKeyConstraints();

        $this->command->info('Successfully truncated all employees and related data!');
    }

    /**
     * Truncate a table if it exists
     */
    private function truncateTable(string $tableName): void
    {
        if (Schema::hasTable($tableName)) {
            DB::table($tableName)->truncate();
            $this->command->info("Truncated table: {$tableName}");
        } else {
            $this->command->warn("Table does not exist: {$tableName}");
        }
    }
}
