<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class TruncateCompanyDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Disable foreign key checks
        Schema::disableForeignKeyConstraints();

        // Truncate deeply nested child tables first
        $this->truncateTable('email_campaign_logs');
        $this->truncateTable('quotation_email_logs');
        $this->truncateTable('lead_remarks');
        $this->truncateTable('quotation_items');
        $this->truncateTable('employee_request_replies');
        $this->truncateTable('fcm_tokens');
        $this->truncateTable('guard_checkins');
        $this->truncateTable('job_location_logs');
        $this->truncateTable('job_notes');
        $this->truncateTable('checkpoint_scans');
        $this->truncateTable('incidents');
        $this->truncateTable('employee_uniforms');
        $this->truncateTable('employee_site_bans');
        $this->truncateTable('notifications');

        // Truncate schedule-related pivot tables
        $this->truncateTable('employee_patroller_schedule');
        $this->truncateTable('employee_schedule');
        $this->truncateTable('schedule_tour_route');
        $this->truncateTable('checkpoint_tour_route');
        $this->truncateTable('patroller_job_sites');
        $this->truncateTable('schedule_wage_type');

        // Truncate employee-related pivot tables
        $this->truncateTable('employee_wage_type');
        $this->truncateTable('employee_identifications');
        $this->truncateTable('employee_experiences');
        $this->truncateTable('employee_skill');

        // Truncate schedule tables
        $this->truncateTable('patroller_schedules');
        $this->truncateTable('schedules');

        // Truncate tour routes and checkpoints
        $this->truncateTable('tour_routes');
        $this->truncateTable('checkpoints');

        // Truncate routes and sites
        $this->truncateTable('routes');
        $this->truncateTable('sites');

        // Truncate employee requests and related
        $this->truncateTable('employee_requests');

        // Truncate employees
        $this->truncateTable('employees');

        // Truncate uniform-related tables
        $this->truncateTable('uniform_variants');
        $this->truncateTable('uniforms');

        // Truncate vehicles
        $this->truncateTable('vehicles');

        // Truncate email campaigns and templates
        $this->truncateTable('email_campaigns');
        $this->truncateTable('email_templates');
        $this->truncateTable('email_signatures');

        // Truncate leads and quotations
        $this->truncateTable('leads');
        $this->truncateTable('quotations');

        // Truncate company settings and related tables
        $this->truncateTable('stat_holidays');
        $this->truncateTable('id_settings');
        $this->truncateTable('company_job_role_visibility');
        $this->truncateTable('request_types');

        // Truncate company branches
        $this->truncateTable('company_branches');

        // Truncate company-user pivot table
        $this->truncateTable('company_user');

        // Finally, truncate the main companies table
        $this->truncateTable('companies');

        // Re-enable foreign key checks
        Schema::enableForeignKeyConstraints();

        $this->command->info('Successfully truncated all companies and related data!');
    }

    /**
     * Truncate a table if it exists
     */
    private function truncateTable(string $tableName): void
    {
        if (Schema::hasTable($tableName)) {
            DB::table($tableName)->truncate();
            $this->command->info("Truncated table: {$tableName}");
        } else {
            $this->command->warn("Table does not exist: {$tableName}");
        }
    }
}
