<?php

namespace Database\Seeders;

use App\Models\TimeZone;
use Illuminate\Database\Seeder;

class TimeZoneSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $timeZones = [
            'Canada/Atlantic',
            'Canada/Central',
            'Canada/Eastern',
            'Canada/Mountain',
            'Canada/Newfoundland',
            'Canada/Pacific',
            'Canada/Saskatchewan',
            'Canada/Yukon',
        ];

        foreach ($timeZones as $tz) {
            TimeZone::updateOrCreate(
                ['name' => $tz],
                ['active' => 1]
            );
        }
    }
}
