<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\Route;
use App\Models\Site;
use App\Models\IdSetting;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class RouteDummySeeder extends Seeder
{
    public function run(): void
    {
        $faker = Faker::create();
        $companies = Company::all();

        foreach ($companies as $company) {
            $this->command->info("Seeding routes for company: {$company->name}");

            $idSetting = IdSetting::where('company_id', $company->id)->first();
            $sites = Site::where('company_id', $company->id)->get();

            if ($sites->count() < 2) {
                $this->command->warn("Not enough sites to create meaningful routes for {$company->name}. Skipping.");
                continue;
            }

            for ($i = 0; $i < 10; $i++) {
                $routeId = $idSetting->route_prefix . str_pad($idSetting->route_next_number, 5, '0', STR_PAD_LEFT);

                $route = Route::create([
                    'company_id' => $company->id,
                    'route_code' => $routeId,
                    'name' => $faker->city . " Patrol Route " . ($i + 1),
                    'rate' => $faker->randomFloat(2, 50, 200),
                    'description' => $faker->sentence(),
                    'active' => true,
                ]);

                // Attach 2-4 sites to each route
                $randomSites = $sites->random(rand(2, min(4, $sites->count())));
                $route->sites()->attach($randomSites->pluck('id'));

                $idSetting->increment('route_next_number');
            }
        }
    }
}
