<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RolePermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Define Permissions
        $permissions = [
            // Employees
            'view employees',
            'create employee',
            'edit employee',
            'delete employee',

            // Sites
            'view sites',
            'create site',
            'edit site',
            'delete site',

            // Routes
            'view routes',
            'create route',
            'edit route',
            'delete route',

            // Schedules
            'view schedules',
            'create schedule',
            'edit schedule',
            'delete schedule',

            // Companies (Admin only)
            'view companies',
            'create company',
            'edit company',
            'delete company',

            // Users & Access (Admin only)
            'view users',
            'create user',
            'edit user',
            'delete user',
            'manage roles',
            'manage permissions',

            // Masters - Time Zones
            'view time zones',
            'create time zone',
            'edit time zone',
            'delete time zone',

            // Masters - Zones
            'view zones',
            'create zone',
            'edit zone',
            'delete zone',

            // Masters - Countries
            'view countries',
            'create country',
            'edit country',
            'delete country',

            // Masters - States
            'view states',
            'create state',
            'edit state',
            'delete state',

            // Masters - Departments
            'view departments',
            'create department',
            'edit department',
            'delete department',

            // Masters - Job Roles
            'view job roles',
            'create job role',
            'edit job role',
            'delete job role',

            // Masters - Wage Types
            'view wage types',
            'create wage type',
            'edit wage type',
            'delete wage type',

            // Masters - Stat Holidays
            'view stat holidays',
            'create stat holiday',
            'edit stat holiday',
            'delete stat holiday',

            // Masters - Skills
            'view skills',
            'create skill',
            'edit skill',
            'delete skill',

            // Communication - Email Signatures
            'view email signatures',
            'create email signature',
            'edit email signature',
            'delete email signature',

            // Communication - Email Templates
            'view email templates',
            'create email template',
            'edit email template',
            'delete email template',

            // Sales - Leads
            'view leads',
            'create lead',
            'edit lead',
            'delete lead',

            // Sales - Quotations
            'view quotations',
            'create quotation',
            'edit quotation',
            'delete quotation',

            // System & Settings
            'manage settings', // General settings fallback
            'manage css settings',
            'manage integrations',
            'manage operational rules',
            'manage security settings',
            'manage id settings',

            // Masters - Duty Positions
            'view positions',
            'create position',
            'edit position',
            'delete position',

            // Logs
            'view activity logs',
            'delete activity logs',
            'view system logs',
            'delete system logs',
        ];

        foreach ($permissions as $permission) {
            Permission::updateOrCreate(['name' => $permission]);
        }

        // Create Roles and Assign Permissions
        $adminRole = Role::updateOrCreate(['name' => 'Admin']);
        $adminRole->syncPermissions(Permission::all());

        $managerRole = Role::updateOrCreate(['name' => 'Manager']);
        $managerRole->syncPermissions([
            'view employees',
            'create employee',
            'edit employee',
            'view sites',
            'create site',
            'edit site',
            'view routes',
            'create route',
            'edit route',
            'view schedules',
            'create schedule',
            'edit schedule',
            'view companies',
        ]);

        // Create Guard roles for both guards to be safe
        Role::updateOrCreate(['name' => 'Guard', 'guard_name' => 'web']);
        Role::updateOrCreate(['name' => 'Guard', 'guard_name' => 'employee']);

        // Assign Admin role to the first user if they exist
        $user = User::first();
        if ($user) {
            $user->assignRole($adminRole);
        }
    }
}
