<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Company;
use App\Models\RequestType;

class RequestTypeSeeder extends Seeder
{
    public function run()
    {
        $companies = Company::all();

        $defaultTypes = [
            [
                'key' => 'leave',
                'name' => 'Leave Request',
                'template' => "I would like to request a leave of absence.\n\nFrom: [Start Date]\nTo: [End Date]\nReason: [Enter Reason]"
            ],
            [
                'key' => 'short_leave',
                'name' => 'Short Day Leave',
                'template' => "I would like to request a short leave.\n\nDate: [Date]\nTime: [Start Time] to [End Time]\nReason: [Enter Reason]"
            ],
            [
                'key' => 'medical',
                'name' => 'Medical Leave',
                'template' => "I am unable to report to work due to medical reasons.\n\nDate(s): [Date]\nDoctor's Note: [Attached/Will Provide]"
            ],
            [
                'key' => 'complaint',
                'name' => 'Complaint (Companion/Colleague)',
                'template' => "I wish to report a concern regarding a colleague/incident.\n\nPerson involved (if any): [Name]\nDetails of incident: "
            ],
            [
                'key' => 'advance',
                'name' => 'Advance Request',
                'template' => "I would like to request a salary advance.\n\nAmount: [Enter Amount]\nReason for request: "
            ],
            [
                'key' => 'resignation',
                'name' => 'Resignation',
                'template' => "Please accept this message as formal notification that I am resigning from my position.\n\nMy last day will be: [Date]\nReason (Optional): "
            ],
            [
                'key' => 'uniform',
                'name' => 'Uniform Request',
                'template' => "I would like to request the following uniform items:\n\nItem(s) Needed:\n1. [Uniform Item Name] - Size: [Size] - Color: [Color]\n2. [Add more items if needed]\n\nReason for request: [New Issue/Replacement/Additional]\nUrgency: [Urgent/Normal]"
            ],
        ];

        foreach ($companies as $company) {
            foreach ($defaultTypes as $type) {
                RequestType::firstOrCreate(
                    [
                        'company_id' => $company->id,
                        'key' => $type['key']
                    ],
                    [
                        'name' => $type['name'],
                        'template' => $type['template'],
                        'is_active' => true
                    ]
                );
            }
        }
    }
}
