<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MasterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Job Roles
        $jobRoles = [
            'Security Guard',
            'Security Supervisor',
            'Site Manager',
            'Operations Manager',
            'Patroller',
            'Control Room Operator',
            'Dispatcher',
            'Loss Prevention Officer',
            'Concierge Security',
            'Mobile Guard'
        ];
        foreach ($jobRoles as $role) {
            \App\Models\JobRole::updateOrCreate(['name' => $role], ['active' => true]);
        }

        // Wage Types
        $wageTypes = ['SIN', 'Cash'];
        foreach ($wageTypes as $type) {
            \App\Models\WageType::updateOrCreate(['name' => $type], ['active' => true]);
        }

        // Canadian Provinces (seeded as States)
        $provinces = [
            'Alberta',
            'British Columbia',
            'Manitoba',
            'New Brunswick',
            'Newfoundland and Labrador',
            'Nova Scotia',
            'Ontario',
            'Prince Edward Island',
            'Quebec',
            'Saskatchewan',
            'Northwest Territories',
            'Nunavut',
            'Yukon'
        ];
        foreach ($provinces as $province) {
            \App\Models\State::updateOrCreate(
                ['name' => $province], 
                ['active' => true, 'country_id' => 1]
            );
        }
    }
}
