<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class LocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $locations = [
            [
                'name' => 'Canada',
                'iso2' => 'CA',
                'iso3' => 'CAN',
                'phone_code' => '1',
                'states' => [
                    ['name' => 'Alberta', 'code' => 'AB'],
                    ['name' => 'British Columbia', 'code' => 'BC'],
                    ['name' => 'Manitoba', 'code' => 'MB'],
                    ['name' => 'New Brunswick', 'code' => 'NB'],
                    ['name' => 'Newfoundland and Labrador', 'code' => 'NL'],
                    ['name' => 'Nova Scotia', 'code' => 'NS'],
                    ['name' => 'Ontario', 'code' => 'ON'],
                    ['name' => 'Prince Edward Island', 'code' => 'PE'],
                    ['name' => 'Quebec', 'code' => 'QC'],
                    ['name' => 'Saskatchewan', 'code' => 'SK'],
                    ['name' => 'Northwest Territories', 'code' => 'NT'],
                    ['name' => 'Nunavut', 'code' => 'NU'],
                    ['name' => 'Yukon', 'code' => 'YT'],
                ]
            ],
            [
                'name' => 'United States',
                'iso2' => 'US',
                'iso3' => 'USA',
                'phone_code' => '1',
                'states' => [
                    ['name' => 'Alabama', 'code' => 'AL'], ['name' => 'Alaska', 'code' => 'AK'], ['name' => 'Arizona', 'code' => 'AZ'],
                    ['name' => 'Arkansas', 'code' => 'AR'], ['name' => 'California', 'code' => 'CA'], ['name' => 'Colorado', 'code' => 'CO'],
                    ['name' => 'Connecticut', 'code' => 'CT'], ['name' => 'Delaware', 'code' => 'DE'], ['name' => 'Florida', 'code' => 'FL'],
                    ['name' => 'Georgia', 'code' => 'GA'], ['name' => 'Hawaii', 'code' => 'HI'], ['name' => 'Idaho', 'code' => 'ID'],
                    ['name' => 'Illinois', 'code' => 'IL'], ['name' => 'Indiana', 'code' => 'IN'], ['name' => 'Iowa', 'code' => 'IA'],
                    ['name' => 'Kansas', 'code' => 'KS'], ['name' => 'Kentucky', 'code' => 'KY'], ['name' => 'Louisiana', 'code' => 'LA'],
                    ['name' => 'Maine', 'code' => 'ME'], ['name' => 'Maryland', 'code' => 'MD'], ['name' => 'Massachusetts', 'code' => 'MA'],
                    ['name' => 'Michigan', 'code' => 'MI'], ['name' => 'Minnesota', 'code' => 'MN'], ['name' => 'Mississippi', 'code' => 'MS'],
                    ['name' => 'Missouri', 'code' => 'MO'], ['name' => 'Montana', 'code' => 'MT'], ['name' => 'Nebraska', 'code' => 'NE'],
                    ['name' => 'Nevada', 'code' => 'NV'], ['name' => 'New Hampshire', 'code' => 'NH'], ['name' => 'New Jersey', 'code' => 'NJ'],
                    ['name' => 'New Mexico', 'code' => 'NM'], ['name' => 'New York', 'code' => 'NY'], ['name' => 'North Carolina', 'code' => 'NC'],
                    ['name' => 'North Dakota', 'code' => 'ND'], ['name' => 'Ohio', 'code' => 'OH'], ['name' => 'Oklahoma', 'code' => 'OK'],
                    ['name' => 'Oregon', 'code' => 'OR'], ['name' => 'Pennsylvania', 'code' => 'PA'], ['name' => 'Rhode Island', 'code' => 'RI'],
                    ['name' => 'South Carolina', 'code' => 'SC'], ['name' => 'South Dakota', 'code' => 'SD'], ['name' => 'Tennessee', 'code' => 'TN'],
                    ['name' => 'Texas', 'code' => 'TX'], ['name' => 'Utah', 'code' => 'UT'], ['name' => 'Vermont', 'code' => 'VT'],
                    ['name' => 'Virginia', 'code' => 'VA'], ['name' => 'Washington', 'code' => 'WA'], ['name' => 'West Virginia', 'code' => 'WV'],
                    ['name' => 'Wisconsin', 'code' => 'WI'], ['name' => 'Wyoming', 'code' => 'WY']
                ]
            ],
            [
                'name' => 'United Kingdom',
                'iso2' => 'GB',
                'iso3' => 'GBR',
                'phone_code' => '44',
                'states' => [
                    ['name' => 'England', 'code' => 'ENG'],
                    ['name' => 'Scotland', 'code' => 'SCT'],
                    ['name' => 'Wales', 'code' => 'WLS'],
                    ['name' => 'Northern Ireland', 'code' => 'NIR']
                ]
            ],
            [
                'name' => 'India',
                'iso2' => 'IN',
                'iso3' => 'IND',
                'phone_code' => '91',
                'states' => [
                    ['name' => 'Andhra Pradesh', 'code' => 'AP'], ['name' => 'Arunachal Pradesh', 'code' => 'AR'], ['name' => 'Assam', 'code' => 'AS'],
                    ['name' => 'Bihar', 'code' => 'BR'], ['name' => 'Chhattisgarh', 'code' => 'CT'], ['name' => 'Goa', 'code' => 'GA'],
                    ['name' => 'Gujarat', 'code' => 'GJ'], ['name' => 'Haryana', 'code' => 'HR'], ['name' => 'Himachal Pradesh', 'code' => 'HP'],
                    ['name' => 'Jharkhand', 'code' => 'JH'], ['name' => 'Karnataka', 'code' => 'KA'], ['name' => 'Kerala', 'code' => 'KL'],
                    ['name' => 'Madhya Pradesh', 'code' => 'MP'], ['name' => 'Maharashtra', 'code' => 'MH'], ['name' => 'Manipur', 'code' => 'MN'],
                    ['name' => 'Meghalaya', 'code' => 'ML'], ['name' => 'Mizoram', 'code' => 'MZ'], ['name' => 'Nagaland', 'code' => 'NL'],
                    ['name' => 'Odisha', 'code' => 'OR'], ['name' => 'Punjab', 'code' => 'PB'], ['name' => 'Rajasthan', 'code' => 'RJ'],
                    ['name' => 'Sikkim', 'code' => 'SK'], ['name' => 'Tamil Nadu', 'code' => 'TN'], ['name' => 'Telangana', 'code' => 'TG'],
                    ['name' => 'Tripura', 'code' => 'TR'], ['name' => 'Uttar Pradesh', 'code' => 'UP'], ['name' => 'Uttarakhand', 'code' => 'UT'],
                    ['name' => 'West Bengal', 'code' => 'WB']
                ]
            ],
            [
                'name' => 'Australia',
                'iso2' => 'AU',
                'iso3' => 'AUS',
                'phone_code' => '61',
                'states' => [
                    ['name' => 'New South Wales', 'code' => 'NSW'],
                    ['name' => 'Queensland', 'code' => 'QLD'],
                    ['name' => 'South Australia', 'code' => 'SA'],
                    ['name' => 'Tasmania', 'code' => 'TAS'],
                    ['name' => 'Victoria', 'code' => 'VIC'],
                    ['name' => 'Western Australia', 'code' => 'WA'],
                    ['name' => 'Australian Capital Territory', 'code' => 'ACT'],
                    ['name' => 'Northern Territory', 'code' => 'NT']
                ]
            ]
        ];

        foreach ($locations as $loc) {
            $country = \App\Models\Country::updateOrCreate(
                ['name' => $loc['name']],
                [
                    'iso2' => $loc['iso2'],
                    'iso3' => $loc['iso3'],
                    'phone_code' => $loc['phone_code'],
                    'active' => true
                ]
            );

            foreach ($loc['states'] as $state) {
                \App\Models\State::updateOrCreate(
                    ['country_id' => $country->id, 'name' => $state['name']],
                    ['code' => $state['code'], 'active' => true]
                );
            }
        }
    }
}
