<?php

namespace Database\Seeders;

use App\Models\Department;
use Illuminate\Database\Seeder;

class DepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $departments = [
            [
                'name' => 'Operations',
                'display_id' => 'DEP001',
                'details' => 'Responsible for day-to-day security operations and site management.',
                'active' => true,
            ],
            [
                'name' => 'Human Resources',
                'display_id' => 'DEP002',
                'details' => 'Handles recruitment, employee relations, and payroll.',
                'active' => true,
            ],
            [
                'name' => 'Finance & Accounting',
                'display_id' => 'DEP003',
                'details' => 'Manages company finances, billing, and financial reporting.',
                'active' => true,
            ],
            [
                'name' => 'Sales & Marketing',
                'display_id' => 'DEP004',
                'details' => 'Focuses on client acquisition and brand promotion.',
                'active' => true,
            ],
            [
                'name' => 'Training & Development',
                'display_id' => 'DEP005',
                'details' => 'Provides training programs for security personnel.',
                'active' => true,
            ],
            [
                'name' => 'IT & Technical Support',
                'display_id' => 'DEP006',
                'details' => 'Maintains technical infrastructure and surveillance systems.',
                'active' => true,
            ],
            [
                'name' => 'Legal & Compliance',
                'display_id' => 'DEP007',
                'details' => 'Ensures regulatory compliance and handles legal matters.',
                'active' => true,
            ],
            [
                'name' => 'Customer Service',
                'display_id' => 'DEP008',
                'details' => 'Handles client inquiries and relationship management.',
                'active' => true,
            ],
            [
                'name' => 'Logistics & Fleet Management',
                'display_id' => 'DEP009',
                'details' => 'Manages company vehicles and equipment logistics.',
                'active' => true,
            ],
            [
                'name' => 'Quality Assurance & Inspection',
                'display_id' => 'DEP010',
                'details' => 'Conducts site audits and ensures service quality standards.',
                'active' => true,
            ],
        ];

        foreach ($departments as $dept) {
            Department::updateOrCreate(['name' => $dept['name']], $dept);
        }
    }
}
