<?php

namespace Database\Seeders;

use App\Models\Company;
use App\Models\TimeZone;
use Illuminate\Database\Seeder;

class CompanySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $timeZones = TimeZone::where('active', 1)->pluck('id')->toArray();
        
        if (empty($timeZones)) {
            $this->command->error('No active time zones found. Please run TimeZoneSeeder first.');
            return;
        }

        $companies = [
            [
                'time_zone_id' => $timeZones[array_rand($timeZones)],
                'name' => 'Falcon Security Services',
                'tagline' => 'Your Safety, Our Priority',
                'contact_person' => 'John Doe',
                'mobile_number' => '+1 555-0101',
                'email' => 'info@falconsecurity.com',
                'website' => 'https://falconsecurity.com',
                'service_tax_number' => 'ST123456789',
                'hst' => 'HST-987654321',
                'cst_no' => 'CST-456789123',
                'cin_no' => 'CIN-L12345MH2025PLC123456',
                'logo' => 'logos/dummy1.png',
                'address_1' => '123 Aviation Way, Toronto, ON',
                'address_2' => 'Suite 400',
            ],
            [
                'time_zone_id' => $timeZones[array_rand($timeZones)],
                'name' => 'Guardian Roaster Corp',
                'tagline' => 'Securing Every Cup',
                'contact_person' => 'Jane Smith',
                'mobile_number' => '+1 555-0202',
                'email' => 'contact@guardianroaster.ca',
                'website' => 'https://guardianroaster.ca',
                'service_tax_number' => 'ST987654321',
                'hst' => 'HST-123456789',
                'cst_no' => 'CST-789123456',
                'cin_no' => 'CIN-L98765BC2025PLC987654',
                'logo' => 'logos/dummy2.png',
                'address_1' => '456 Coffee Lane, Vancouver, BC',
                'address_2' => null,
            ],
            [
                'time_zone_id' => $timeZones[array_rand($timeZones)],
                'name' => 'Apex Guarding Solutions',
                'tagline' => 'Peak Protection',
                'contact_person' => 'Robert Tech',
                'mobile_number' => '+1 555-0303',
                'email' => 'admin@apexguarding.com',
                'website' => null,
                'service_tax_number' => null,
                'hst' => 'HST-555666777',
                'cst_no' => null,
                'cin_no' => 'CIN-L55555AB2025PLC555555',
                'logo' => 'logos/dummy3.png',
                'address_1' => '789 Peak Summit, Calgary, AB',
                'address_2' => 'Industrial Area',
            ],
        ];

        foreach ($companies as $companyData) {
            Company::create($companyData);
        }
    }
}
