<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('patroller_schedules', function (Blueprint $table) {
            $table->string('status')->change();
            $table->string('job_status')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('patroller_schedules', function (Blueprint $table) {
            $table->enum('status', ['pending', 'active', 'upcoming', 'missed', 'completed'])->default('pending')->change();
            $table->enum('job_status', ['pending', 'in_progress', 'completed', 'auto_ended'])->default('pending')->change();
        });
    }
};
