<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('quotations', function (Blueprint $table) {
            $table->timestamp('email_sent_at')->nullable()->after('status');
            $table->timestamp('last_email_sent_at')->nullable()->after('email_sent_at');
            $table->integer('email_sent_count')->default(0)->after('last_email_sent_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('quotations', function (Blueprint $table) {
            $table->dropColumn(['email_sent_at', 'last_email_sent_at', 'email_sent_count']);
        });
    }
};
