<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('job_notes')) {
            Schema::create('job_notes', function (Blueprint $blueprint) {
                $blueprint->id();
                $blueprint->unsignedBigInteger('employee_id');
                $blueprint->string('job_type'); // guard or patroller
                $blueprint->unsignedBigInteger('job_id');
                $blueprint->text('note');
                $blueprint->timestamps();

                $blueprint->foreign('employee_id')->references('id')->on('employees')->onDelete('cascade');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('job_notes');
    }
};
