<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guard_checkins', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The caller (Customer Care)
            $table->foreignId('employee_id')->constrained()->onDelete('cascade'); // The guard
            $table->foreignId('schedule_id')->nullable()->constrained()->onDelete('cascade'); // For static jobs
            $table->foreignId('patroller_schedule_id')->nullable()->constrained()->onDelete('cascade'); // For patrol jobs
            $table->string('checkin_type')->default('call'); // call, video, visit
            $table->string('location_reported')->nullable();
            $table->boolean('is_verified')->default(false);
            $table->text('notes')->nullable();
            $table->json('images')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guard_checkins');
    }
};
