<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('checkpoint_scans', function (Blueprint $table) {
            $table->text('employee_message')->nullable()->after('evidence_image');
            $table->json('additional_photos')->nullable()->after('employee_message');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('checkpoint_scans', function (Blueprint $table) {
            $table->dropColumn(['employee_message', 'additional_photos']);
        });
    }
};
